/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.launcher.daemon.client.DaemonCancelForwarder;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientInputForwarder;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonDisappearedException;
import org.gradle.launcher.daemon.client.DaemonInitialConnectException;
import org.gradle.launcher.daemon.client.NoUsableDaemonFoundException;
import org.gradle.launcher.daemon.client.StaleDaemonAddressException;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.daemon.server.api.DaemonStoppedException;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class DaemonClient
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private static final Logger LOGGER = Logging.getLogger(DaemonClient.class);
    private final DaemonConnector connector;
    private final OutputEventListener outputEventListener;
    private final ExplainingSpec<DaemonContext> compatibilitySpec;
    private final InputStream buildStandardInput;
    private final ExecutorFactory executorFactory;
    private final IdGenerator<UUID> idGenerator;
    private final ProcessEnvironment processEnvironment;

    public DaemonClient(DaemonConnector connector, OutputEventListener outputEventListener, ExplainingSpec<DaemonContext> compatibilitySpec, InputStream buildStandardInput, ExecutorFactory executorFactory, IdGenerator<UUID> idGenerator, ProcessEnvironment processEnvironment) {
        this.connector = connector;
        this.outputEventListener = outputEventListener;
        this.compatibilitySpec = compatibilitySpec;
        this.buildStandardInput = buildStandardInput;
        this.executorFactory = executorFactory;
        this.idGenerator = idGenerator;
        this.processEnvironment = processEnvironment;
    }

    protected IdGenerator<UUID> getIdGenerator() {
        return this.idGenerator;
    }

    protected DaemonConnector getConnector() {
        return this.connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters parameters, BuildRequestContext requestContext) {
        DaemonClientConnection connection;
        UUID buildId = this.idGenerator.generateId();
        ArrayList accumulatedExceptions = Lists.newArrayList();
        LOGGER.debug("Executing build {} in daemon client {pid={}}", buildId, this.processEnvironment.maybeGetPid());
        int saneNumberOfAttempts = 100;
        for (int i = 1; i < saneNumberOfAttempts && (connection = this.connector.connect(this.compatibilitySpec)) != null; ++i) {
            try {
                Build build2 = new Build(buildId, connection.getDaemon().getToken(), action, requestContext.getClient(), requestContext.getStartTime(), requestContext.isInteractive(), parameters);
                BuildActionResult buildActionResult = this.executeBuild(build2, connection, requestContext.getCancellationToken(), requestContext.getEventConsumer());
                return buildActionResult;
            }
            catch (DaemonInitialConnectException e) {
                LOGGER.debug("{}, Trying a different daemon...", e.getMessage());
                accumulatedExceptions.add(e);
                continue;
            }
            finally {
                connection.stop();
            }
        }
        DaemonClientConnection connection2 = this.connector.startDaemon(this.compatibilitySpec);
        try {
            Build build3 = new Build(buildId, connection2.getDaemon().getToken(), action, requestContext.getClient(), requestContext.getStartTime(), requestContext.isInteractive(), parameters);
            BuildActionResult buildActionResult = this.executeBuild(build3, connection2, requestContext.getCancellationToken(), requestContext.getEventConsumer());
            return buildActionResult;
        }
        catch (DaemonInitialConnectException e) {
            throw new NoUsableDaemonFoundException("A new daemon was started but could not be connected to: pid=" + connection2.getDaemon() + ", address= " + connection2.getDaemon().getAddress() + ".", (Iterable<? extends Throwable>)accumulatedExceptions);
        }
        finally {
            connection2.stop();
        }
    }

    protected BuildActionResult executeBuild(Build build2, DaemonClientConnection connection, BuildCancellationToken cancellationToken, BuildEventConsumer buildEventConsumer) throws DaemonInitialConnectException {
        Object result2;
        try {
            LOGGER.debug("Connected to daemon {}. Dispatching request {}.", connection.getDaemon(), build2);
            connection.dispatch(build2);
            result2 = connection.receive();
        }
        catch (StaleDaemonAddressException e) {
            LOGGER.debug("Connected to a stale daemon address.", e);
            throw new DaemonInitialConnectException("Connected to a stale daemon address.", e);
        }
        if (result2 == null) {
            this.connector.markDaemonAsUnavailable(connection.getDaemon());
            throw new DaemonInitialConnectException("The first result from the daemon was empty. The daemon process may have died or a non-daemon process is reusing the same port.");
        }
        LOGGER.debug("Received result {} from daemon {} (build should be starting).", result2, connection.getDaemon());
        DaemonDiagnostics diagnostics2 = null;
        if (result2 instanceof BuildStarted) {
            diagnostics2 = ((BuildStarted)result2).getDiagnostics();
            result2 = this.monitorBuild(build2, diagnostics2, connection, cancellationToken, buildEventConsumer);
        }
        LOGGER.debug("Received result {} from daemon {} (build should be done).", result2, connection.getDaemon());
        try {
            connection.dispatch(new Finished());
        }
        catch (DaemonConnectionException e) {
            LOGGER.debug("Could not send finished message to the daemon.", e);
        }
        if (result2 instanceof Failure) {
            Throwable failure = (Throwable)((Failure)result2).getValue();
            if (failure instanceof DaemonStoppedException && cancellationToken.isCancellationRequested()) {
                return BuildActionResult.cancelled(new BuildCancelledException("Daemon was stopped to handle build cancel request.", failure));
            }
            throw UncheckedException.throwAsUncheckedException(failure);
        }
        if (result2 instanceof DaemonUnavailable) {
            throw new DaemonInitialConnectException("The daemon we connected to was unavailable: " + ((DaemonUnavailable)result2).getReason());
        }
        if (result2 instanceof Result) {
            return (BuildActionResult)((Result)result2).getValue();
        }
        throw this.invalidResponse(result2, build2, diagnostics2);
    }

    private Object monitorBuild(Build build2, DaemonDiagnostics diagnostics2, Connection<Message> connection, BuildCancellationToken cancellationToken, BuildEventConsumer buildEventConsumer) {
        Result result2;
        Message object;
        DaemonClientInputForwarder inputForwarder = new DaemonClientInputForwarder(this.buildStandardInput, connection, this.executorFactory);
        DaemonCancelForwarder cancelForwarder = new DaemonCancelForwarder(connection, cancellationToken);
        try {
            cancelForwarder.start();
            inputForwarder.start();
            int objectsReceived = 0;
            while (true) {
                object = (Message)connection.receive();
                ++objectsReceived;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Received object #{}, type: {}", objectsReceived++, object == null ? null : object.getClass().getName());
                }
                if (object != null) break block8;
                result2 = this.handleDaemonDisappearance(build2, diagnostics2);
                break;
            }
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable(cancelForwarder, inputForwarder).stop();
            throw throwable;
        }
        {
            block9: {
                block8: {
                    CompositeStoppable.stoppable(cancelForwarder, inputForwarder).stop();
                    return result2;
                }
                if (object instanceof OutputMessage) {
                    this.outputEventListener.onOutput(((OutputMessage)object).getEvent());
                    break block9;
                }
                if (object instanceof BuildEvent) {
                    buildEventConsumer.dispatch(((BuildEvent)object).getPayload());
                    break block9;
                }
                Message message = object;
                CompositeStoppable.stoppable(cancelForwarder, inputForwarder).stop();
                return message;
            }
            continue;
        }
    }

    private Result handleDaemonDisappearance(Build build2, DaemonDiagnostics diagnostics2) {
        LOGGER.error("The message received from the daemon indicates that the daemon has disappeared.\nBuild request sent: {}\nAttempting to read last messages from the daemon log...", build2);
        LOGGER.error(diagnostics2.describe());
        this.findCrashLogFile(build2, diagnostics2).ifPresent(crashLogFile -> LOGGER.error("JVM crash log found: " + new ConsoleRenderer().asClickableFileUrl((File)crashLogFile)));
        throw new DaemonDisappearedException();
    }

    private Optional<File> findCrashLogFile(Build build2, DaemonDiagnostics diagnostics2) {
        String crashLogFileName = "hs_err_pid" + diagnostics2.getPid() + ".log";
        ArrayList<File> candidates = new ArrayList<File>();
        candidates.add(new File(build2.getParameters().getCurrentDir(), crashLogFileName));
        candidates.add(new File(diagnostics2.getDaemonLog().getParent(), crashLogFileName));
        DaemonClient.findCrashLogFile(crashLogFileName).ifPresent(candidates::add);
        return candidates.stream().filter(File::isFile).findFirst();
    }

    private static Optional<File> findCrashLogFile(String crashLogFileName) {
        String javaTmpDir = SystemProperties.getInstance().getJavaIoTmpDir();
        if (javaTmpDir != null && !javaTmpDir.isEmpty()) {
            return Optional.of(new File(javaTmpDir, crashLogFileName));
        }
        return Optional.empty();
    }

    private IllegalStateException invalidResponse(Object response, Build command, DaemonDiagnostics diagnostics2) {
        String diagnosticsMessage = diagnostics2 == null ? "No diagnostics available." : diagnostics2.describe();
        return new IllegalStateException(String.format("Received invalid response from the daemon: '%s' is a result of a type we don't have a strategy to handle. Earlier, '%s' request was sent to the daemon. Diagnostics:\n%s", response, command, diagnosticsMessage));
    }
}

