/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.gradle.profiler.CompositeProfilerFactory;
import org.gradle.profiler.Profiler;

public abstract class ProfilerFactory {
    public static final ProfilerFactory NONE = new ProfilerFactory(){

        @Override
        public Profiler createFromOptions(OptionSet parsedOptions) {
            return Profiler.NONE;
        }

        @Override
        public String getName() {
            return "none";
        }
    };
    private static final Map<String, ProfilerFactory> AVAILABLE_PROFILERS;

    public static Set<String> getAvailableProfilers() {
        return AVAILABLE_PROFILERS.keySet();
    }

    public static void configureParser(OptionParser parser) {
        for (ProfilerFactory profiler : AVAILABLE_PROFILERS.values()) {
            profiler.addOptions(parser);
        }
    }

    private static ProfilerFactory of(String name) {
        ProfilerFactory profiler = AVAILABLE_PROFILERS.get(name.toLowerCase());
        if (profiler == null) {
            throw new IllegalArgumentException("Unknown profiler : " + name);
        }
        return profiler;
    }

    public static ProfilerFactory of(List<String> profilersList) {
        if (profilersList.size() == 1) {
            String first = profilersList.get(0);
            return ProfilerFactory.of(first);
        }
        return new CompositeProfilerFactory(profilersList.stream().map(ProfilerFactory::of).collect(Collectors.toList()));
    }

    public abstract Profiler createFromOptions(OptionSet var1);

    public void addOptions(OptionParser parser) {
    }

    public abstract String getName();

    static {
        ServiceLoader<ProfilerFactory> factories = ServiceLoader.load(ProfilerFactory.class);
        LinkedHashMap factoriesByName = new LinkedHashMap();
        factories.forEach(factory -> factoriesByName.put(factory.getName(), factory));
        AVAILABLE_PROFILERS = Collections.unmodifiableMap(factoriesByName);
    }
}

