/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.jprofiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JProfilerConfig {
    private final String homeDir;
    private final String config;
    private final String sessionId;
    private String configFile;
    private final boolean recordAlloc;
    private final boolean recordMonitors;
    private final List<String> recordedProbes;
    private final Set<String> probesWithEventRecording;
    private final Set<String> probesWithSpecialRecording;
    private final boolean heapDump;
    private int port;

    public JProfilerConfig(String homeDir, String config, String sessionId, String configFile, boolean recordAlloc, boolean recordMonitors, boolean heapDump, List<String> recordedProbeSpecs) {
        this.homeDir = homeDir;
        this.sessionId = sessionId;
        this.configFile = configFile;
        this.recordAlloc = recordAlloc;
        this.config = config;
        this.recordMonitors = recordMonitors;
        this.heapDump = heapDump;
        ArrayList<String> recordedProbes = new ArrayList<String>();
        HashSet<String> probesWithEventRecording = new HashSet<String>();
        HashSet<String> probesWithSpecialRecording = new HashSet<String>();
        for (String probeSpec : recordedProbeSpecs) {
            int separatorPos = probeSpec.indexOf(58);
            if (separatorPos > -1) {
                String probeName = probeSpec.substring(0, separatorPos);
                String probeOptions = probeSpec.substring(separatorPos + 1);
                recordedProbes.add(probeName);
                if (probeOptions.contains("+events")) {
                    probesWithEventRecording.add(probeName);
                }
                if (!probeOptions.contains("+special")) continue;
                probesWithSpecialRecording.add(probeName);
                continue;
            }
            recordedProbes.add(probeSpec);
        }
        this.recordedProbes = Collections.unmodifiableList(recordedProbes);
        this.probesWithEventRecording = Collections.unmodifiableSet(probesWithEventRecording);
        this.probesWithSpecialRecording = Collections.unmodifiableSet(probesWithSpecialRecording);
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getConfig() {
        return this.config;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public boolean isRecordAlloc() {
        return this.recordAlloc;
    }

    public boolean isRecordMonitors() {
        return this.recordMonitors;
    }

    public List<String> getRecordedProbes() {
        return this.recordedProbes;
    }

    public Set<String> getProbesWithEventRecording() {
        return this.probesWithEventRecording;
    }

    public Set<String> getProbesWithSpecialRecording() {
        return this.probesWithSpecialRecording;
    }

    public boolean isHeapDump() {
        return this.heapDump;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

