/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.jprofiler;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ProfilerFactory;
import org.gradle.profiler.jprofiler.JProfiler;
import org.gradle.profiler.jprofiler.JProfilerConfig;
import org.gradle.profiler.jprofiler.JProfilerProfiler;

public class JProfilerProfilerFactory
extends ProfilerFactory {
    private ArgumentAcceptingOptionSpec<String> homeDir;
    private ArgumentAcceptingOptionSpec<String> configOption;
    private ArgumentAcceptingOptionSpec<String> sessionIdOption;
    private ArgumentAcceptingOptionSpec<String> configFileOption;
    private OptionSpecBuilder allocOption;
    private OptionSpecBuilder monitorsOption;
    private OptionSpecBuilder heapDumpOption;
    private ArgumentAcceptingOptionSpec<String> probesOption;

    @Override
    public void addOptions(OptionParser parser) {
        this.homeDir = parser.accepts("jprofiler-home", "JProfiler installation directory").availableIf("profile", new String[0]).withOptionalArg().ofType(String.class).defaultsTo((Object)JProfiler.getDefaultHomeDir(), (Object[])new String[0]);
        this.configOption = parser.accepts("jprofiler-config", "JProfiler built-in configuration name (sampling|sampling-all|instrumentation)").availableIf("profile", new String[0]).withOptionalArg().ofType(String.class).defaultsTo((Object)"sampling", (Object[])new String[0]);
        this.sessionIdOption = parser.accepts("jprofiler-session-id", "Use session with this id from the JProfiler installation instead of using the built-in config").availableUnless("jprofiler-config", new String[0]).withRequiredArg().ofType(String.class);
        this.configFileOption = parser.accepts("jprofiler-config-file", "Use another config file for --jprofiler-session-id instead of the global config file").availableIf("jprofiler-session-id", new String[0]).withRequiredArg().ofType(String.class);
        this.allocOption = parser.accepts("jprofiler-alloc", "Record allocations").availableIf("profile", new String[0]);
        this.monitorsOption = parser.accepts("jprofiler-monitors", "Record monitor usage").availableIf("profile", new String[0]);
        this.heapDumpOption = parser.accepts("jprofiler-heapdump", "Trigger heap dump after a build").availableIf("profile", new String[0]);
        this.probesOption = parser.accepts("jprofiler-probes", "Record probes (builtin.FileProbe|builtin.SocketProbe|builtin.ProcessProbe|builtin.ClassLoaderProbe|builtin.ExceptionProbe, see Controller javadoc for the full list) separated by commas, add :+events to probe name to enable event recording").availableIf("profile", new String[0]).withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').defaultsTo((Object[])new String[0]);
    }

    @Override
    public Profiler createFromOptions(OptionSet parsedOptions) {
        return new JProfilerProfiler(this.newConfigObject(parsedOptions));
    }

    @Override
    public String getName() {
        return "jprofiler";
    }

    private JProfilerConfig newConfigObject(OptionSet parsedOptions) {
        return new JProfilerConfig((String)parsedOptions.valueOf(this.homeDir), (String)parsedOptions.valueOf(this.configOption), (String)parsedOptions.valueOf(this.sessionIdOption), (String)parsedOptions.valueOf(this.configFileOption), parsedOptions.has((OptionSpec)this.allocOption), parsedOptions.has((OptionSpec)this.monitorsOption), parsedOptions.has((OptionSpec)this.heapDumpOption), parsedOptions.valuesOf(this.probesOption));
    }
}

