/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.jprofiler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.Logging;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.jprofiler.JProfiler;
import org.gradle.profiler.jprofiler.JProfilerConfig;

public class JProfilerController
implements InstrumentingProfiler.SnapshotCapturingProfilerController {
    private final JProfilerConfig jProfilerConfig;
    private final ScenarioSettings settings;
    private MBeanServerConnection connection;
    private JMXConnector connector;
    private ObjectName objectName;

    public JProfilerController(ScenarioSettings settings, JProfilerConfig jProfilerConfig) {
        this.settings = settings;
        this.jProfilerConfig = jProfilerConfig;
    }

    @Override
    public void startRecording(String pid) throws IOException, InterruptedException {
        this.invoke("startCPURecording", false);
        if (this.jProfilerConfig.isRecordAlloc()) {
            this.invoke("startAllocRecording", false);
        }
        if (this.jProfilerConfig.isRecordMonitors()) {
            this.invoke("startMonitorRecording", new Object[0]);
        }
        for (String probeName : this.jProfilerConfig.getRecordedProbes()) {
            boolean eventRecording = this.jProfilerConfig.getProbesWithEventRecording().contains(probeName);
            boolean specialRecording = this.jProfilerConfig.getProbesWithSpecialRecording().contains(probeName);
            this.invoke("startProbeRecording", probeName, eventRecording, specialRecording);
        }
        if (this.jProfilerConfig.isHeapDump() && this.hasOperation("markHeap")) {
            this.invoke("markHeap", new Object[0]);
        }
    }

    @Override
    public void stopRecording(String pid) throws IOException, InterruptedException {
        this.invoke("stopCPURecording", new Object[0]);
        if (this.jProfilerConfig.isRecordAlloc()) {
            this.invoke("stopAllocRecording", new Object[0]);
        }
        if (this.jProfilerConfig.isRecordMonitors()) {
            this.invoke("stopMonitorRecording", new Object[0]);
        }
        for (String probeName : this.jProfilerConfig.getRecordedProbes()) {
            this.invoke("stopProbeRecording", probeName);
        }
    }

    @Override
    public void captureSnapshot(String pid) throws IOException, InterruptedException {
        if (this.jProfilerConfig.isHeapDump()) {
            this.invoke("triggerHeapDump", new Object[0]);
        }
        this.invoke("saveSnapshot", this.getSnapshotPath());
    }

    @Override
    public void stopSession() throws IOException, InterruptedException {
        this.closeConnection();
    }

    private String getSnapshotPath() {
        return JProfiler.getSnapshotPath(this.settings);
    }

    private void ensureConnected() throws IOException {
        if (this.connector == null) {
            try {
                JMXServiceURL jmxUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + this.jProfilerConfig.getPort() + "/jmxrmi");
                JMXConnector newConnector = JMXConnectorFactory.newJMXConnector(jmxUrl, Collections.emptyMap());
                newConnector.connect();
                this.connection = newConnector.getMBeanServerConnection();
                this.objectName = new ObjectName("com.jprofiler.api.agent.mbean:type=RemoteController");
                if (!this.connection.isRegistered(this.objectName)) {
                    throw new RuntimeException("JProfiler MBean not found");
                }
                this.connector = newConnector;
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void closeConnection() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                Logging.detailed().println("Could not close connection to profiled VM.");
            }
            finally {
                this.connector = null;
            }
        }
    }

    private void invoke(String operationName, Object ... parameterValues) throws IOException {
        this.ensureConnected();
        String[] parameterTypes = (String[])Arrays.stream(parameterValues).map(Object::getClass).map(this::replaceWrapperWithPrimitive).map(Class::getName).toArray(String[]::new);
        try {
            this.connection.invoke(this.objectName, operationName, parameterValues, parameterTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    private Class replaceWrapperWithPrimitive(Class c) {
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        return c;
    }

    private boolean hasOperation(String operationName) throws IOException {
        try {
            return Arrays.stream(this.connection.getMBeanInfo(this.objectName).getOperations()).anyMatch(operationInfo -> operationInfo.getName().equals(operationName));
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }
}

