/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ide.DefaultIdeProvider;
import org.gradle.profiler.ide.Ide;
import org.gradle.profiler.ide.IdeProvider;
import org.gradle.profiler.ide.idea.IDEA;
import org.gradle.profiler.ide.studio.AndroidStudio;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioDefinition;

public class StudioInstallDirSupplier
implements Supplier<Path> {
    private final InvocationSettings invocationSettings;
    private final StudioGradleScenarioDefinition.StudioGradleBuildConfiguration buildConfiguration;
    private final IdeProvider<Ide> ideProvider;

    public StudioInstallDirSupplier(InvocationSettings invocationSettings, StudioGradleScenarioDefinition.StudioGradleBuildConfiguration buildConfiguration) {
        this.invocationSettings = invocationSettings;
        this.buildConfiguration = buildConfiguration;
        this.ideProvider = new DefaultIdeProvider();
    }

    @Override
    public Path get() {
        IDEA ide;
        File studioInstallDir = this.invocationSettings.getStudioInstallDir();
        if (studioInstallDir != null) {
            return studioInstallDir.toPath();
        }
        String ideType = this.buildConfiguration.getIdeType();
        String ideVersion = this.buildConfiguration.getIdeVersion();
        String ideBuildType = this.buildConfiguration.getIdeBuildType();
        if (ideType.equals("IC")) {
            ide = new IDEA(ideBuildType, ideVersion);
        } else if (ideType.equals("AI")) {
            ide = new AndroidStudio(ideVersion);
        } else {
            throw new IllegalArgumentException("Unknown IDE product was requested");
        }
        return this.ideProvider.provideIde((Ide)ide, this.buildConfiguration.getIdeHome().toAbsolutePath(), this.buildConfiguration.getIdeHome().resolve("downloads").toAbsolutePath()).toPath();
    }
}

