/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.datasource.FileChannelDataSource;
import org.jetbrains.zip.signer.digest.DigestUtils;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.signing.SigningKt;
import org.jetbrains.zip.signer.verifier.ZipVerifier;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;
import org.jetbrains.zip.signer.zip.ZipUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J.\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/zip/signer/signing/ZipSigner;", "", "()V", "generateSignedZip", "", "inputZipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "outputMetadata", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "outputFileChannel", "Ljava/nio/channels/FileChannel;", "getOutputDigests", "", "Lorg/jetbrains/zip/signer/metadata/Digest;", "inputSigningBlock", "requiredDigest", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "sign", "inputFile", "Ljava/io/File;", "outputFile", "certificates", "Ljava/security/cert/X509Certificate;", "signatureProvider", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "inputDataSource", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "unsign", "lib"})
@ExperimentalUnsignedTypes
public final class ZipSigner {
    @NotNull
    public static final ZipSigner INSTANCE = new ZipSigner();

    private ZipSigner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void sign(@NotNull File inputFile, @NotNull File outputFile, @NotNull List<? extends X509Certificate> certificates, @NotNull SignatureProvider signatureProvider) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter((Object)signatureProvider, (String)"signatureProvider");
        Closeable closeable = new RandomAccessFile(inputFile, "r");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            RandomAccessFile inputRandomAccessFile = (RandomAccessFile)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new RandomAccessFile(outputFile, "rw");
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                RandomAccessFile outputRandomAccessFile = (RandomAccessFile)closeable2;
                boolean bl6 = false;
                outputRandomAccessFile.setLength(0L);
                FileChannel fileChannel = inputRandomAccessFile.getChannel();
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"inputRandomAccessFile.channel");
                DataSource dataSource = new FileChannelDataSource(fileChannel, 0L, null, 6, null);
                fileChannel = outputRandomAccessFile.getChannel();
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"outputRandomAccessFile.channel");
                INSTANCE.sign(dataSource, fileChannel, certificates, signatureProvider);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void unsign(@NotNull File inputFile, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Closeable closeable = new RandomAccessFile(inputFile, "r");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            int n;
            RandomAccessFile inputRandomAccessFile = (RandomAccessFile)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new RandomAccessFile(outputFile, "rw");
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                RandomAccessFile outputRandomAccessFile = (RandomAccessFile)closeable2;
                boolean bl6 = false;
                outputRandomAccessFile.setLength(0L);
                FileChannel fileChannel = inputRandomAccessFile.getChannel();
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"inputRandomAccessFile.channel");
                FileChannelDataSource inputDataSource = new FileChannelDataSource(fileChannel, 0L, null, 6, null);
                ZipSectionsInformation inputZipSectionsInformation = ZipUtils.INSTANCE.findZipSectionsInformation(inputDataSource);
                ZipMetadata inputSigningBlock = ZipMetadata.Companion.findInZip(inputDataSource, inputZipSectionsInformation);
                ZipSections inputZipSections = ZipUtils.INSTANCE.findZipSections$lib(inputDataSource, inputZipSectionsInformation, inputSigningBlock);
                DataSource dataSource = inputZipSections.getBeforeSigningBlockSection();
                FileChannel fileChannel2 = outputRandomAccessFile.getChannel();
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel2, (String)"outputRandomAccessFile.channel");
                DataSource.DefaultImpls.feed$default(dataSource, fileChannel2, 0L, 0L, 6, null);
                DataSource dataSource2 = inputZipSections.getCentralDirectorySection();
                fileChannel2 = outputRandomAccessFile.getChannel();
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel2, (String)"outputRandomAccessFile.channel");
                DataSource.DefaultImpls.feed$default(dataSource2, fileChannel2, 0L, 0L, 6, null);
                ByteBuffer outputEocdRecord = ZipUtils.INSTANCE.getModifiedEocdRecord(inputZipSections, 0);
                n = outputRandomAccessFile.getChannel().write(outputEocdRecord);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            int n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void sign(DataSource inputDataSource, FileChannel outputFileChannel, List<? extends X509Certificate> certificates, SignatureProvider signatureProvider) {
        if (!CertificateUtils.INSTANCE.isValidCertificateChain(certificates)) {
            throw new IllegalArgumentException("Provided certificates doesn't form a valid certificate trust chain");
        }
        ZipSectionsInformation inputZipSectionsInformation = ZipUtils.INSTANCE.findZipSectionsInformation(inputDataSource);
        ZipMetadata inputSigningBlock = ZipMetadata.Companion.findInZip(inputDataSource, inputZipSectionsInformation);
        ZipSections inputZipSections = ZipUtils.INSTANCE.findZipSections$lib(inputDataSource, inputZipSectionsInformation, inputSigningBlock);
        List<Digest> outputDigests = this.getOutputDigests(inputSigningBlock, inputZipSections, signatureProvider.getSignatureAlgorithm().getContentDigestAlgorithm());
        SignerBlock newSignerBlock = SigningKt.generateSignerBlock(certificates, signatureProvider, outputDigests);
        ZipMetadata zipMetadata = inputSigningBlock;
        List<SignerBlock> list = zipMetadata == null ? null : zipMetadata.getSigners();
        List outputSignerBlocks = CollectionsKt.plus((Collection)(list == null ? CollectionsKt.emptyList() : list), (Object)newSignerBlock);
        ZipMetadata outputMetadata = new ZipMetadata(outputDigests, outputSignerBlocks);
        this.generateSignedZip(inputZipSections, outputMetadata, outputFileChannel);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Digest> getOutputDigests(ZipMetadata inputSigningBlock, ZipSections inputZipSections, ContentDigestAlgorithm requiredDigest) {
        List list;
        if (inputSigningBlock != null) {
            void $this$mapTo$iv$iv;
            ZipVerifier.INSTANCE.checkDigests$lib(inputZipSections, inputSigningBlock);
            Iterable $this$map$iv = inputSigningBlock.getDigests();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Digest digest = (Digest)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ContentDigestAlgorithm contentDigestAlgorithm = it.getAlgorithm();
                collection.add(contentDigestAlgorithm);
            }
            if (!((List)destination$iv$iv).contains((Object)requiredDigest)) {
                List missingDigests = DigestUtils.computeDigest$default(DigestUtils.INSTANCE, CollectionsKt.listOf((Object)((Object)requiredDigest)), inputZipSections, 0, 4, null);
                list = CollectionsKt.plus((Collection)inputSigningBlock.getDigests(), (Iterable)missingDigests);
            } else {
                list = inputSigningBlock.getDigests();
            }
        } else {
            list = DigestUtils.computeDigest$default(DigestUtils.INSTANCE, CollectionsKt.listOf((Object)((Object)requiredDigest)), inputZipSections, 0, 4, null);
        }
        return list;
    }

    private final void generateSignedZip(ZipSections inputZipSections, ZipMetadata outputMetadata, FileChannel outputFileChannel) {
        ByteBuffer outputEocdRecord = ZipUtils.INSTANCE.getModifiedEocdRecord(inputZipSections, outputMetadata.getSize());
        DataSource.DefaultImpls.feed$default(inputZipSections.getBeforeSigningBlockSection(), outputFileChannel, 0L, 0L, 6, null);
        outputFileChannel.write(ByteBuffer.wrap(outputMetadata.toByteArray()));
        DataSource.DefaultImpls.feed$default(inputZipSections.getCentralDirectorySection(), outputFileChannel, 0L, 0L, 6, null);
        outputFileChannel.write(outputEocdRecord);
    }
}

