/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.launcher;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.instrument.GradleInstrumentation;
import org.gradle.profiler.studio.launcher.StudioLauncher;
import org.gradle.profiler.studio.tools.StudioSandboxCreator;

public class StudioLauncherProvider {
    private static final boolean SHOULD_RUN_HEADLESS = Boolean.getBoolean("studio.tests.headless");
    private static final List<String> DEFAULT_MACOS_STARTER_PATHS = ImmutableList.of((Object)"Contents/MacOS/studio", (Object)"Contents/MacOS/idea");
    private static final List<String> DEFAULT_WINDOWS_STARTER_PATHS = ImmutableList.of((Object)"bin/studio.bat", (Object)"bin/idea.bat");
    private static final List<String> DEFAULT_LINUX_STARTER_PATHS = ImmutableList.of((Object)"bin/studio.sh", (Object)"bin/idea.sh");
    private final Path studioInstallDir;
    private final StudioSandboxCreator.StudioSandbox studioSandbox;
    private final List<String> studioJvmArgs;
    private final List<String> ideaProperties;
    private boolean enableStudioPluginParameters;
    private int studioPluginPort;
    private boolean enableStudioAgentParameters;
    private int studioAgentPort;
    private int studioStartDetectorPort;

    public StudioLauncherProvider(Path studioInstallDir, StudioSandboxCreator.StudioSandbox studioSandbox, List<String> studioJvmArgs, List<String> ideaProperties) {
        this.studioInstallDir = studioInstallDir;
        this.studioSandbox = studioSandbox;
        this.studioJvmArgs = studioJvmArgs;
        this.ideaProperties = ideaProperties;
    }

    public StudioLauncherProvider withStudioPluginParameters(int studioStartDetectorPort, int studioPluginPort) {
        this.enableStudioPluginParameters = true;
        this.studioStartDetectorPort = studioStartDetectorPort;
        this.studioPluginPort = studioPluginPort;
        return this;
    }

    public StudioLauncherProvider withStudioAgentParameters(int studioAgentPort) {
        this.enableStudioAgentParameters = true;
        this.studioAgentPort = studioAgentPort;
        return this;
    }

    public StudioLauncher get() {
        Path startCommand = StudioLauncherProvider.getStartCommand(this.studioInstallDir);
        List<String> additionalJvmArgs = this.getAdditionalJvmArgs();
        String headlessCommand = SHOULD_RUN_HEADLESS ? "headless-starter" : "";
        return new StudioLauncher(startCommand, headlessCommand, this.studioInstallDir, additionalJvmArgs, this.studioSandbox, this.ideaProperties);
    }

    private List<String> getAdditionalJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        if (this.enableStudioAgentParameters) {
            String agentJar = GradleInstrumentation.unpackPlugin("studio-agent").getAbsolutePath();
            String supportJar = GradleInstrumentation.unpackPlugin("instrumentation-support").getAbsolutePath();
            String asmJar = GradleInstrumentation.unpackPlugin("asm").getAbsolutePath();
            String protocolJar = GradleInstrumentation.unpackPlugin("client-protocol").getAbsolutePath();
            List<String> sharedJars = Arrays.asList(asmJar, protocolJar);
            jvmArgs.add(String.format("-javaagent:%s=%s,%s", agentJar, this.studioAgentPort, supportJar));
            jvmArgs.add("--add-exports=java.base/jdk.internal.misc=ALL-UNNAMED");
            jvmArgs.add("-Xbootclasspath/a:" + Joiner.on((String)File.pathSeparator).join(sharedJars));
        }
        jvmArgs.addAll(this.studioJvmArgs);
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        if (this.enableStudioPluginParameters) {
            systemProperties.put("gradle.profiler.startup.port", String.valueOf(this.studioStartDetectorPort));
            systemProperties.put("gradle.profiler.port", String.valueOf(this.studioPluginPort));
        }
        this.studioSandbox.getConfigDir().ifPresent(path -> systemProperties.put("idea.config.path", path.toString()));
        this.studioSandbox.getSystemDir().ifPresent(path -> systemProperties.put("idea.system.path", path.toString()));
        systemProperties.put("idea.plugins.path", this.studioSandbox.getPluginsDir().toString());
        systemProperties.put("idea.log.path", this.studioSandbox.getLogsDir().toString());
        systemProperties.put("idea.trust.all.projects", "true");
        systemProperties.put("idea.gradle.distributionType", "BUNDLED");
        if (SHOULD_RUN_HEADLESS) {
            systemProperties.put("java.awt.headless", "true");
        }
        systemProperties.forEach((k, v) -> jvmArgs.add(String.format("-D%s=%s", k, v)));
        return jvmArgs;
    }

    private static Path getStartCommand(Path studioInstallDir) {
        return StudioLauncherProvider.getDefaultJavaPathsForOs().stream().map(studioInstallDir::resolve).filter(path -> path.toFile().exists()).findFirst().orElseThrow(() -> new RuntimeException("Could not find Java executable in " + studioInstallDir));
    }

    private static List<String> getDefaultJavaPathsForOs() {
        if (OperatingSystem.isMacOS()) {
            return DEFAULT_MACOS_STARTER_PATHS;
        }
        if (OperatingSystem.isWindows()) {
            return DEFAULT_WINDOWS_STARTER_PATHS;
        }
        return DEFAULT_LINUX_STARTER_PATHS;
    }
}

