/*
 * Decompiled with CFR 0.152.
 */
package org.monte.screenrecorder;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.gui.JLabelHyperlinkHandler;
import org.monte.media.gui.Worker;
import org.monte.media.gui.datatransfer.DropFileTransferHandler;
import org.monte.media.math.Rational;
import org.monte.screenrecorder.JRecordingAreaFrame;
import org.monte.screenrecorder.ScreenRecorder;

public class ScreenRecorderMain
extends JFrame {
    private Handler handler = new Handler();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
    private volatile Worker recorder;
    private ScreenRecorder screenRecorder;
    private int depth;
    private int format;
    private int encoding;
    private int cursor;
    private int audioRate;
    private int audioSource;
    private int area;
    private double screenRate;
    private double mouseRate;
    private File movieFolder;
    private JComboBox areaChoice;
    private JLabel areaLabel;
    private JComboBox audioRateChoice;
    private JLabel audioRateLabel;
    private JComboBox audioSourceChoice;
    private JLabel audioSourceLabel;
    private JComboBox colorsChoice;
    private JLabel colorsLabel;
    private JComboBox cursorChoice;
    private JComboBox encodingChoice;
    private JLabel encodingLabel;
    private JComboBox formatChoice;
    private JLabel formatLabel;
    private JLabel infoLabel;
    private JLabel mouseLabel;
    private JSpinner mouseRateField;
    private JLabel mouseRateLabel;
    private JSpinner screenRateField;
    private JLabel screenRateLabel;
    private JButton selectAreaButton;
    private JButton startStopButton;
    private JLabel stateLabel;

    public ScreenRecorderMain() {
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(12, 20, 20, 20));
        this.initComponents();
        String version = ScreenRecorderMain.class.getPackage().getImplementationVersion();
        if (version != null) {
            int p = version.indexOf(32);
            this.setTitle(this.getTitle() + " " + version.substring(0, p == -1 ? version.length() : p));
        }
        final Preferences prefs = Preferences.userNodeForPackage(ScreenRecorderMain.class);
        this.movieFolder = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new File(System.getProperty("user.home") + File.separator + "Videos") : new File(System.getProperty("user.home") + File.separator + "Movies");
        this.movieFolder = new File(prefs.get("ScreenRecorder.movieFolder", this.movieFolder.toString()));
        final String infoLabelText = this.infoLabel.getText();
        this.infoLabel.setText(infoLabelText.replaceAll("\"Movies\"", "\"<a href=\"" + this.movieFolder.toURI() + "\">" + this.movieFolder.getName() + "</a>\""));
        new JLabelHyperlinkHandler(this.infoLabel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File f = new File(new URI(e.getActionCommand()));
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    Desktop.getDesktop().open(f);
                }
                catch (URISyntaxException ex) {
                    System.err.println("ScreenRecorderMain bad href " + e.getActionCommand() + ", " + ex);
                }
                catch (IOException ex) {
                    System.err.println("ScreenRecorderMain io exception: " + ex);
                }
            }
        });
        this.infoLabel.setTransferHandler(new DropFileTransferHandler(1, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenRecorderMain.this.movieFolder = new File(e.getActionCommand());
                prefs.put("ScreenRecorder.movieFolder", ScreenRecorderMain.this.movieFolder.toString());
                ScreenRecorderMain.this.infoLabel.setText(infoLabelText.replaceAll("\"Movies\"", "\"<a href=\"" + ScreenRecorderMain.this.movieFolder.toURI() + "\">" + ScreenRecorderMain.this.movieFolder.getName() + "</a>\""));
            }
        }));
        this.depth = Math.min(Math.max(0, prefs.getInt("ScreenRecording.colorDepth", 3)), this.colorsChoice.getItemCount() - 1);
        this.colorsChoice.setSelectedIndex(this.depth);
        this.format = Math.min(Math.max(0, prefs.getInt("ScreenRecording.format", 0)), this.formatChoice.getItemCount() - 1);
        this.formatChoice.setSelectedIndex(this.format);
        this.encoding = Math.min(Math.max(0, prefs.getInt("ScreenRecording.encoding", 0)), this.encodingChoice.getItemCount() - 1);
        this.encodingChoice.setSelectedIndex(this.encoding);
        this.cursor = Math.min(Math.max(0, prefs.getInt("ScreenRecording.cursor", 1)), this.cursorChoice.getItemCount() - 1);
        this.cursorChoice.setSelectedIndex(this.cursor);
        this.screenRate = prefs.getDouble("ScreenRecording.screenRate", 15.0);
        SpinnerNumberModel screenRateModel = new SpinnerNumberModel(this.screenRate, 1.0, 30.0, 1.0);
        this.screenRateField.setModel(screenRateModel);
        this.mouseRate = prefs.getDouble("ScreenRecording.mouseRate", 30.0);
        SpinnerNumberModel mouseRateModel = new SpinnerNumberModel(this.mouseRate, 1.0, 30.0, 1.0);
        this.mouseRateField.setModel(mouseRateModel);
        this.audioRateChoice.setModel(new DefaultComboBoxModel<Object>(new Object[]{new AudioRateItem("8.000 Hz", 8000, 16), new AudioRateItem("11.025 Hz", 11025, 16), new AudioRateItem("22.050 Hz", 22050, 16), new AudioRateItem("44.100 Hz", 44100, 16)}));
        this.audioRate = prefs.getInt("ScreenRecording.audioRate", 0);
        this.audioRateChoice.setSelectedIndex(this.audioRate);
        this.audioSourceChoice.setModel(new DefaultComboBoxModel<AudioSourceItem>(ScreenRecorderMain.getAudioSources()));
        this.audioSource = prefs.getInt("ScreenRecording.audioSource", 0);
        this.audioSourceChoice.setSelectedIndex(this.audioSource);
        Dimension customDim = new Dimension(prefs.getInt("ScreenRecording.customAreaWidth", 1024), prefs.getInt("ScreenRecording.customAreaHeight", 768));
        Point customLoc = new Point(prefs.getInt("ScreenRecording.customAreaX", 100), prefs.getInt("ScreenRecording.customAreaY", 100));
        this.areaChoice.setModel(new DefaultComboBoxModel<Object>(new Object[]{new AreaItem("Entire Screen", null, 8), new AreaItem("Center 1280 x 720", new Dimension(1280, 720), 0), new AreaItem("Center 1024 x 768", new Dimension(1024, 768), 0), new AreaItem("Center   800 x 600", new Dimension(800, 600), 0), new AreaItem("Center   640 x 480", new Dimension(640, 480), 0), new AreaItem("Top Left 1280 x 720", new Dimension(1280, 720), 8), new AreaItem("Top Left 1024 x 768", new Dimension(1024, 768), 8), new AreaItem("Top Left   800 x 600", new Dimension(800, 600), 8), new AreaItem("Top Left   640 x 480", new Dimension(640, 480), 8), new AreaItem("Bottom Left 1280 x 720", new Dimension(1280, 720), 6), new AreaItem("Bottom Left 1024 x 768", new Dimension(1024, 768), 6), new AreaItem("Bottom Left   800 x 600", new Dimension(800, 600), 6), new AreaItem("Bottom Left   640 x 480", new Dimension(640, 480), 6), new AreaItem("Custom: " + customLoc.x + ", " + customLoc.y + "; " + customDim.width + " x " + customDim.height + "", customDim, null, 8, customLoc)}));
        this.areaChoice.setMaximumRowCount(16);
        this.area = prefs.getInt("ScreenRecording.area", 0);
        this.areaChoice.setSelectedIndex(Math.min(this.areaChoice.getItemCount() - 1, Math.max(0, this.area)));
        this.getRootPane().setDefaultButton(this.startStopButton);
        this.updateEncodingChoice();
        this.pack();
    }

    private void initComponents() {
        this.formatLabel = new JLabel();
        this.formatChoice = new JComboBox();
        this.colorsLabel = new JLabel();
        this.colorsChoice = new JComboBox();
        this.infoLabel = new JLabel();
        this.startStopButton = new JButton();
        this.mouseLabel = new JLabel();
        this.cursorChoice = new JComboBox();
        this.audioRateLabel = new JLabel();
        this.audioRateChoice = new JComboBox();
        this.screenRateLabel = new JLabel();
        this.screenRateField = new JSpinner();
        this.mouseRateLabel = new JLabel();
        this.mouseRateField = new JSpinner();
        this.encodingLabel = new JLabel();
        this.encodingChoice = new JComboBox();
        this.areaLabel = new JLabel();
        this.areaChoice = new JComboBox();
        this.selectAreaButton = new JButton();
        this.stateLabel = new JLabel();
        this.audioSourceLabel = new JLabel();
        this.audioSourceChoice = new JComboBox();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(0);
        this.setTitle("Monte Screen Recorder");
        this.setResizable(false);
        this.addWindowListener(formListener);
        this.formatLabel.setText("Format:");
        this.formatChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"AVI", "QuickTime"}));
        this.formatChoice.addActionListener(formListener);
        this.colorsLabel.setText("Colors:");
        this.colorsChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Hundreds", "Thousands", "Millions"}));
        this.infoLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.infoLabel.setText("<html>The recording will be stored in the folder \"Movies\".<br> Drop a folder on this text to change the storage location.<br> A new file will be created every hour or when the file size limit is reached.<br> <br>This window will be minized before the recording starts.<br> To stop the recording, restore this window and press the Stop button.<br> ");
        this.startStopButton.setText("Start");
        this.startStopButton.addActionListener(formListener);
        this.mouseLabel.setText("Mouse:");
        this.cursorChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"No Cursor", "Black Cursor", "White Cursor"}));
        this.audioRateLabel.setText("Audio Rate:");
        this.audioRateChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"44.100 kHz"}));
        this.screenRateLabel.setText("Screen Rate:");
        this.mouseRateLabel.setText("Mouse Rate:");
        this.encodingLabel.setText("Encoding:");
        this.encodingChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Screen Capture", "Run Length", "None", "PNG", "JPEG 100 %", "JPEG   50 %"}));
        this.areaLabel.setText("Area:");
        this.areaChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Entire Screen", "0 0,  1024 x 768", " "}));
        this.selectAreaButton.setText("Custom Area...");
        this.selectAreaButton.addActionListener(formListener);
        this.stateLabel.setHorizontalAlignment(11);
        this.stateLabel.setText(" ");
        this.audioSourceLabel.setText("Audio:");
        this.audioSourceChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"No Audio", "44.100 kHz"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.stateLabel, -2, 190, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.startStopButton).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorsLabel).addComponent(this.mouseLabel).addComponent(this.formatLabel).addComponent(this.areaLabel).addComponent(this.audioSourceLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatChoice, -2, -1, -2).addComponent(this.colorsChoice, -2, -1, -2).addComponent(this.cursorChoice, -2, -1, -2).addComponent(this.audioSourceChoice, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.screenRateLabel, GroupLayout.Alignment.TRAILING).addComponent(this.mouseRateLabel, GroupLayout.Alignment.TRAILING)).addComponent(this.encodingLabel).addComponent(this.audioRateLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.audioRateChoice, -2, -1, -2).addComponent(this.encodingChoice, -2, -1, -2).addComponent(this.screenRateField, -2, 77, -2).addComponent(this.mouseRateField, -2, 77, -2))).addGroup(layout.createSequentialGroup().addComponent(this.areaChoice, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAreaButton)))).addComponent(this.infoLabel)).addContainerGap()));
        layout.linkSize(0, this.audioRateChoice, this.colorsChoice, this.cursorChoice, this.formatChoice);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatChoice, -2, -1, -2).addComponent(this.formatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colorsChoice, -2, -1, -2).addComponent(this.colorsLabel)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cursorChoice, -2, -1, -2).addComponent(this.mouseLabel))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingChoice, -2, -1, -2).addComponent(this.encodingLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.screenRateField, -2, -1, -2).addComponent(this.screenRateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mouseRateField, -2, -1, -2).addComponent(this.mouseRateLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.audioRateChoice, -2, -1, -2).addComponent(this.audioRateLabel).addComponent(this.audioSourceLabel).addComponent(this.audioSourceChoice, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.areaChoice, -2, -1, -2).addComponent(this.areaLabel).addComponent(this.selectAreaButton)).addGap(18, 18, 18).addComponent(this.infoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startStopButton).addComponent(this.stateLabel)).addContainerGap()));
        this.pack();
    }

    private static Vector<AudioSourceItem> getAudioSources() {
        Vector<AudioSourceItem> l = new Vector<AudioSourceItem>();
        l.add(new AudioSourceItem("None", null, false));
        l.add(new AudioSourceItem("Default Input", null, true));
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        DataLine.Info lineInfo = new DataLine.Info(TargetDataLine.class, new AudioFormat(44100.0f, 16, 2, true, true));
        for (Mixer.Info info : mixers) {
            Mixer mixer = AudioSystem.getMixer(info);
            if (!mixer.isLineSupported(lineInfo)) continue;
            l.add(new AudioSourceItem(info.getName(), info));
        }
        return l;
    }

    private void updateValues() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenRecorderMain.class);
        this.format = this.formatChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.format", this.format);
        this.encoding = this.encodingChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.encoding", this.encoding);
        this.depth = this.colorsChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.colorDepth", this.depth);
        this.cursor = this.cursorChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.cursor", this.cursor);
        this.audioRate = this.audioRateChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.audioRate", this.audioRate);
        this.audioSource = this.audioSourceChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.audioSource", this.audioSource);
        this.area = this.areaChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.area", this.area);
        if (this.screenRateField.getValue() instanceof Double) {
            this.screenRate = (Double)this.screenRateField.getValue();
            prefs.putDouble("ScreenRecording.screenRate", this.screenRate);
        }
        if (this.mouseRateField.getValue() instanceof Double) {
            this.mouseRate = (Double)this.mouseRateField.getValue();
            prefs.putDouble("ScreenRecording.mouseRate", this.mouseRate);
        }
    }

    private void start() throws IOException, AWTException {
        this.updateValues();
        if (this.screenRecorder == null) {
            String crsr;
            String videoFormatName;
            String compressorName;
            String mimeType;
            int bitDepth;
            this.setSettingsEnabled(false);
            this.stateLabel.setForeground(Color.RED);
            this.stateLabel.setText("Recording...");
            float quality = 1.0f;
            switch (this.depth) {
                default: {
                    bitDepth = 8;
                    break;
                }
                case 1: {
                    bitDepth = 16;
                    break;
                }
                case 2: {
                    bitDepth = 24;
                }
            }
            block4 : switch (this.format) {
                default: {
                    mimeType = "video/avi";
                    switch (this.encoding) {
                        default: {
                            compressorName = "tscc";
                            videoFormatName = "tscc";
                            break;
                        }
                        case 1: {
                            compressorName = "RLE ";
                            videoFormatName = "RLE ";
                            bitDepth = 8;
                            break;
                        }
                        case 2: {
                            compressorName = "DIB ";
                            videoFormatName = "DIB ";
                            if (bitDepth != 16) break block4;
                            bitDepth = 24;
                            break;
                        }
                        case 3: {
                            compressorName = "png ";
                            videoFormatName = "png ";
                            bitDepth = 24;
                            break;
                        }
                        case 4: {
                            compressorName = "MJPG";
                            videoFormatName = "MJPG";
                            bitDepth = 24;
                            break;
                        }
                        case 5: {
                            compressorName = "MJPG";
                            videoFormatName = "MJPG";
                            bitDepth = 24;
                            quality = 0.5f;
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    mimeType = "video/quicktime";
                    switch (this.encoding) {
                        default: {
                            if (bitDepth == 8) {
                                videoFormatName = "rle ";
                                compressorName = "Animation";
                                break block4;
                            }
                            compressorName = "tscc";
                            videoFormatName = "tscc";
                            compressorName = "tscc";
                            break block4;
                        }
                        case 1: {
                            videoFormatName = "rle ";
                            compressorName = "Animation";
                            break block4;
                        }
                        case 2: {
                            videoFormatName = "raw ";
                            compressorName = "NONE";
                            break block4;
                        }
                        case 3: {
                            videoFormatName = "png ";
                            compressorName = "PNG";
                            bitDepth = 24;
                            break block4;
                        }
                        case 4: {
                            videoFormatName = "jpeg";
                            compressorName = "Photo - JPEG";
                            bitDepth = 24;
                            break block4;
                        }
                        case 5: 
                    }
                    videoFormatName = "jpeg";
                    compressorName = "Photo - JPEG";
                    bitDepth = 24;
                    quality = 0.5f;
                }
            }
            AudioSourceItem src = (AudioSourceItem)this.audioSourceChoice.getItemAt(this.audioSource);
            AudioRateItem rate = (AudioRateItem)this.audioRateChoice.getItemAt(this.audioRate);
            Mixer.Info mixerInfo = src.mixerInfo;
            int audioRate = src.isEnabled ? rate.sampleRate : 0;
            int audioBitsPerSample = rate.bitsPerSample;
            switch (this.cursor) {
                default: {
                    crsr = null;
                    break;
                }
                case 1: {
                    crsr = "black";
                    break;
                }
                case 2: {
                    crsr = "white";
                }
            }
            GraphicsConfiguration cfg = this.getGraphicsConfiguration();
            Rectangle areaRect = null;
            Dimension outputDimension = null;
            AreaItem item = (AreaItem)this.areaChoice.getItemAt(this.area);
            areaRect = item.getBounds(cfg);
            outputDimension = item.outputDimension;
            if (outputDimension == null) {
                outputDimension = areaRect.getSize();
            }
            this.screenRecorder = new ScreenRecorder(cfg, areaRect, new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, mimeType}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, videoFormatName, VideoFormatKeys.CompressorNameKey, compressorName, VideoFormatKeys.WidthKey, outputDimension.width, VideoFormatKeys.HeightKey, outputDimension.height, VideoFormatKeys.DepthKey, bitDepth, VideoFormatKeys.FrameRateKey, Rational.valueOf(this.screenRate), VideoFormatKeys.QualityKey, Float.valueOf(quality), VideoFormatKeys.KeyFrameIntervalKey, (int)(this.screenRate * 60.0)}), crsr == null ? null : new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, crsr, VideoFormatKeys.FrameRateKey, Rational.valueOf(this.mouseRate)}), audioRate == 0 ? null : new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.SampleRateKey, Rational.valueOf(audioRate), AudioFormatKeys.SampleSizeInBitsKey, audioBitsPerSample}), this.movieFolder);
            if (mixerInfo != null) {
                this.screenRecorder.setAudioMixer(AudioSystem.getMixer(mixerInfo));
            }
            this.startStopButton.setText("Stop");
            this.screenRecorder.addChangeListener(this.handler);
            this.screenRecorder.start();
        }
    }

    public void setSettingsEnabled(boolean b) {
        for (Component c : this.getContentPane().getComponents()) {
            if (c == this.startStopButton || c == this.stateLabel) continue;
            c.setEnabled(b);
        }
        ((JComponent)this.getContentPane()).invalidate();
        ((JComponent)this.getContentPane()).revalidate();
    }

    private void stop() {
        if (this.screenRecorder != null) {
            final ScreenRecorder r = this.screenRecorder;
            this.startStopButton.setEnabled(false);
            this.stateLabel.setForeground(Color.RED);
            this.stateLabel.setText("Stopping...");
            this.screenRecorder = null;
            new Worker(){

                protected Object construct() throws Exception {
                    r.stop();
                    return null;
                }

                @Override
                protected void finished() {
                    ScreenRecorder.State state = r.getState();
                    ScreenRecorderMain.this.setSettingsEnabled(true);
                    ScreenRecorderMain.this.startStopButton.setEnabled(true);
                    ScreenRecorderMain.this.startStopButton.setText("Start");
                    ScreenRecorderMain.this.stateLabel.setForeground(Color.RED);
                    ScreenRecorderMain.this.stateLabel.setText(" ");
                }
            }.start();
        }
    }

    private void recordingFailed() {
        if (this.screenRecorder != null) {
            this.screenRecorder = null;
            this.startStopButton.setEnabled(true);
            this.startStopButton.setText("Start");
            this.setExtendedState(0);
            JOptionPane.showMessageDialog(this, "<html><b>Sorry. Screen Recording failed.</b>", "Screen Recorder", 0);
        }
    }

    private void updateEncodingChoice() {
        int index = this.encodingChoice.getSelectedIndex();
        switch (this.formatChoice.getSelectedIndex()) {
            case 0: {
                this.encodingChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Screen Capture", "Run Length", "None", "PNG", "JPEG 100 %", "JPEG  50 %"}));
                break;
            }
            case 1: {
                this.encodingChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Screen Capture", "Animation", "None", "PNG", "JPEG 100 %", "JPEG  50 %"}));
            }
        }
        this.encodingChoice.setSelectedIndex(index);
    }

    private void startStopPerformed(ActionEvent evt) {
        if (this.screenRecorder == null) {
            this.setExtendedState(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScreenRecorderMain.this.start();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ScreenRecorderMain.this.setExtendedState(0);
                        JOptionPane.showMessageDialog(ScreenRecorderMain.this, "<html><b>Sorry. Screen Recording failed.</b><br>" + t.getMessage(), "Screen Recorder", 0);
                        ScreenRecorderMain.this.stop();
                    }
                }
            });
        } else {
            this.stop();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stop();
        this.setVisible(false);
        this.dispose();
    }

    private void formWindowDeiconified(WindowEvent evt) {
    }

    private void formatChoicePerformed(ActionEvent evt) {
        this.updateEncodingChoice();
    }

    private void selectAreaPerformed(ActionEvent evt) {
        final JRecordingAreaFrame f = new JRecordingAreaFrame();
        AreaItem ai = (AreaItem)this.areaChoice.getSelectedItem();
        Rectangle r = ai.getBounds(this.getGraphicsConfiguration());
        f.setBounds(r);
        f.updateLabel();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ScreenRecorderMain.this.areaChoice.setSelectedIndex(ScreenRecorderMain.this.areaChoice.getItemCount() - 1);
                AreaItem ai = (AreaItem)ScreenRecorderMain.this.areaChoice.getSelectedItem();
                ai.location = f.getLocation();
                ai.inputDimension = f.getSize();
                ai.alignment = 8;
                ai.outputDimension = null;
                ai.title = "Custom: " + ((AreaItem)ai).location.x + ", " + ((AreaItem)ai).location.y + "; " + ((AreaItem)ai).inputDimension.width + " x " + ((AreaItem)ai).inputDimension.height;
                f.setVisible(false);
                f.dispose();
                ScreenRecorderMain.this.setVisible(true);
                f.removeWindowListener(this);
                Preferences prefs = Preferences.userNodeForPackage(ScreenRecorderMain.class);
                prefs.putInt("ScreenRecording.customAreaX", ((AreaItem)ai).location.x);
                prefs.putInt("ScreenRecording.customAreaY", ((AreaItem)ai).location.y);
                prefs.putInt("ScreenRecording.customAreaWidth", ((AreaItem)ai).inputDimension.width);
                prefs.putInt("ScreenRecording.customAreaHeight", ((AreaItem)ai).inputDimension.height);
                ((JComponent)ScreenRecorderMain.this.getContentPane()).invalidate();
                ((JComponent)ScreenRecorderMain.this.getContentPane()).revalidate();
            }
        });
        this.setVisible(false);
        f.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new ScreenRecorderMain().setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener,
    WindowListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ScreenRecorderMain.this.formatChoice) {
                ScreenRecorderMain.this.formatChoicePerformed(evt);
            } else if (evt.getSource() == ScreenRecorderMain.this.startStopButton) {
                ScreenRecorderMain.this.startStopPerformed(evt);
            } else if (evt.getSource() == ScreenRecorderMain.this.selectAreaButton) {
                ScreenRecorderMain.this.selectAreaPerformed(evt);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == ScreenRecorderMain.this) {
                ScreenRecorderMain.this.formWindowClosing(evt);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
            if (evt.getSource() == ScreenRecorderMain.this) {
                ScreenRecorderMain.this.formWindowDeiconified(evt);
            }
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }
    }

    private static class AreaItem {
        private String title;
        private Dimension inputDimension;
        private Dimension outputDimension;
        private int alignment;
        private Point location;

        public AreaItem(String title, Dimension dim, int alignment) {
            this(title, dim, null, alignment, new Point(0, 0));
        }

        public AreaItem(String title, Dimension inputDim, Dimension outputDim, int alignment, Point location) {
            this.title = title;
            this.inputDimension = inputDim;
            this.outputDimension = outputDim;
            this.alignment = alignment;
            this.location = location;
        }

        public String toString() {
            return this.title;
        }

        public Rectangle getBounds(GraphicsConfiguration cfg) {
            Rectangle areaRect = null;
            if (this.inputDimension != null) {
                areaRect = new Rectangle(0, 0, this.inputDimension.width, this.inputDimension.height);
            }
            this.outputDimension = this.outputDimension;
            Rectangle screenBounds = cfg.getBounds();
            if (areaRect == null) {
                areaRect = (Rectangle)screenBounds.clone();
            }
            switch (this.alignment) {
                case 0: {
                    areaRect.x = screenBounds.x + (screenBounds.width - areaRect.width) / 2;
                    areaRect.y = screenBounds.y + (screenBounds.height - areaRect.height) / 2;
                    break;
                }
                case 8: {
                    areaRect.x = screenBounds.x;
                    areaRect.y = screenBounds.y;
                    break;
                }
                case 6: {
                    areaRect.x = screenBounds.x;
                    areaRect.y = screenBounds.y + screenBounds.height - areaRect.height;
                    break;
                }
            }
            areaRect.translate(this.location.x, this.location.y);
            areaRect = areaRect.intersection(screenBounds);
            return areaRect;
        }
    }

    private static class AudioSourceItem {
        private String title;
        private Mixer.Info mixerInfo;
        private boolean isEnabled;

        public AudioSourceItem(String title, Mixer.Info mixerInfo) {
            this(title, mixerInfo, true);
        }

        public AudioSourceItem(String title, Mixer.Info mixerInfo, boolean isEnabled) {
            this.title = title;
            this.mixerInfo = mixerInfo;
            this.isEnabled = isEnabled;
        }

        public String toString() {
            return this.title;
        }
    }

    private static class AudioRateItem {
        private String title;
        private int sampleRate;
        private int bitsPerSample;

        public AudioRateItem(String title, int sampleRate, int bitsPerSample) {
            this.title = title;
            this.sampleRate = sampleRate;
            this.bitsPerSample = bitsPerSample;
        }

        public String toString() {
            return this.title;
        }
    }

    private class Handler
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScreenRecorder r = ScreenRecorderMain.this.screenRecorder;
            if (r != null && r.getState() == ScreenRecorder.State.FAILED) {
                ScreenRecorderMain.this.recordingFailed();
            }
        }
    }
}

