/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.model.lion3;

import com.jetbrains.fus.reporting.model.exceptions.FusReportingEmptyReportValidationException;
import com.jetbrains.fus.reporting.model.exceptions.FusReportingValidationException;
import com.jetbrains.fus.reporting.model.lion3.FusRecord;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/jetbrains/fus/reporting/model/lion3/FusReport;", "", "product", "", "device", "recorder", "internal", "", "records", "", "Lcom/jetbrains/fus/reporting/model/lion3/FusRecord;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Iterable;)V", "getDevice", "()Ljava/lang/String;", "getInternal", "()Z", "getProduct", "getRecorder", "getRecords", "()Ljava/lang/Iterable;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "model"})
public final class FusReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String product;
    @NotNull
    private final String device;
    @NotNull
    private final String recorder;
    private final boolean internal;
    @NotNull
    private final Iterable<FusRecord> records;
    private static final Pattern PRODUCT_PATTERN = Pattern.compile("^[A-Z]+$");

    public FusReport(@NotNull String product, @NotNull String device, @NotNull String recorder, boolean internal, @NotNull Iterable<FusRecord> records) {
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullParameter(records, (String)"records");
        this.product = product;
        this.device = device;
        this.recorder = recorder;
        this.internal = internal;
        this.records = records;
        if (!PRODUCT_PATTERN.matcher(this.product).matches()) {
            throw new FusReportingValidationException("Product code " + this.product + " should contain uppercase latin letters only and be at least ole symbol long");
        }
        if (!CollectionsKt.any(this.records)) {
            throw new FusReportingEmptyReportValidationException();
        }
    }

    public /* synthetic */ FusReport(String string, String string2, String string3, boolean bl, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "FUS";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl, iterable);
    }

    @NotNull
    public final String getProduct() {
        return this.product;
    }

    @NotNull
    public final String getDevice() {
        return this.device;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    public final boolean getInternal() {
        return this.internal;
    }

    @NotNull
    public final Iterable<FusRecord> getRecords() {
        return this.records;
    }

    @NotNull
    public final String component1() {
        return this.product;
    }

    @NotNull
    public final String component2() {
        return this.device;
    }

    @NotNull
    public final String component3() {
        return this.recorder;
    }

    public final boolean component4() {
        return this.internal;
    }

    @NotNull
    public final Iterable<FusRecord> component5() {
        return this.records;
    }

    @NotNull
    public final FusReport copy(@NotNull String product, @NotNull String device, @NotNull String recorder, boolean internal, @NotNull Iterable<FusRecord> records) {
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullParameter(records, (String)"records");
        return new FusReport(product, device, recorder, internal, records);
    }

    public static /* synthetic */ FusReport copy$default(FusReport fusReport, String string, String string2, String string3, boolean bl, Iterable iterable, int n, Object object) {
        if ((n & 1) != 0) {
            string = fusReport.product;
        }
        if ((n & 2) != 0) {
            string2 = fusReport.device;
        }
        if ((n & 4) != 0) {
            string3 = fusReport.recorder;
        }
        if ((n & 8) != 0) {
            bl = fusReport.internal;
        }
        if ((n & 0x10) != 0) {
            iterable = fusReport.records;
        }
        return fusReport.copy(string, string2, string3, bl, iterable);
    }

    @NotNull
    public String toString() {
        return "FusReport(product=" + this.product + ", device=" + this.device + ", recorder=" + this.recorder + ", internal=" + this.internal + ", records=" + this.records + ')';
    }

    public int hashCode() {
        int result = this.product.hashCode();
        result = result * 31 + this.device.hashCode();
        result = result * 31 + this.recorder.hashCode();
        int n = this.internal ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.records.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FusReport)) {
            return false;
        }
        FusReport fusReport = (FusReport)other;
        if (!Intrinsics.areEqual((Object)this.product, (Object)fusReport.product)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.device, (Object)fusReport.device)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.recorder, (Object)fusReport.recorder)) {
            return false;
        }
        if (this.internal != fusReport.internal) {
            return false;
        }
        return Intrinsics.areEqual(this.records, fusReport.records);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/fus/reporting/model/lion3/FusReport$Companion;", "", "()V", "PRODUCT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

