/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J8\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J8\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0016H\u0007J\"\u0010\u001b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\"\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventEscaper;", "", "()V", "SYMBOLS_TO_REPLACE", "", "SYMBOLS_TO_REPLACE_FIELD_NAME", "VALIDATION_RESULT_TYPES", "", "cleanupForLegacyRulesIfNeeded", "str", "containsChar", "", "c", "", "containsSystemSymbols", "value", "toReplace", "escape", "escapeEventData", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "eventData", "", "escapeEventDataValue", "escapeEventIdOrFieldValue", "escapeFieldName", "escapeIds", "escapeInternal", "allowSpaces", "isAscii", "isAsciiControl", "isProhibitedSymbol", "isSymbolToReplace", "isWhiteSpaceToReplace", "replace", "ap-validation"})
public final class StatisticsEventEscaper {
    @NotNull
    public static final StatisticsEventEscaper INSTANCE;
    @NotNull
    private static final String SYMBOLS_TO_REPLACE = ":;, ";
    @NotNull
    private static final String SYMBOLS_TO_REPLACE_FIELD_NAME = ".:;, ";
    @NotNull
    private static final Set<String> VALIDATION_RESULT_TYPES;

    private StatisticsEventEscaper() {
    }

    @JvmStatic
    @NotNull
    public static final String escapeEventIdOrFieldValue(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.escapeInternal(str, null, true);
    }

    @JvmStatic
    @NotNull
    public static final String escape(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.escapeInternal(str, SYMBOLS_TO_REPLACE, false);
    }

    @JvmStatic
    @NotNull
    public static final String escapeFieldName(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (VALIDATION_RESULT_TYPES.contains(str)) {
            return str;
        }
        return INSTANCE.escapeInternal(str, SYMBOLS_TO_REPLACE_FIELD_NAME, false);
    }

    @JvmStatic
    @Nullable
    public static final String cleanupForLegacyRulesIfNeeded(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.containsSystemSymbols(str, SYMBOLS_TO_REPLACE) ? INSTANCE.replace(str, SYMBOLS_TO_REPLACE, false) : null;
    }

    @JvmStatic
    @NotNull
    public static final HashMap<String, Object> escapeEventData(@NotNull Map<String, ? extends Object> eventData) {
        Intrinsics.checkNotNullParameter(eventData, (String)"eventData");
        HashMap<String, Object> escapedData = new HashMap<String, Object>();
        for (Map.Entry<String, ? extends Object> entry : eventData.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ((Map)escapedData).put(StatisticsEventEscaper.escapeFieldName(key), StatisticsEventEscaper.escapeEventDataValue(value));
        }
        return escapedData;
    }

    @JvmStatic
    @NotNull
    public static final HashMap<String, String> escapeIds(@NotNull Map<String, String> eventData) {
        Intrinsics.checkNotNullParameter(eventData, (String)"eventData");
        HashMap<String, String> escapedData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : eventData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            ((Map)escapedData).put(StatisticsEventEscaper.escapeFieldName(key), StatisticsEventEscaper.escapeEventIdOrFieldValue(value));
        }
        return escapedData;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Object escapeEventDataValue(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof String) {
            object = StatisticsEventEscaper.escapeEventIdOrFieldValue((String)value);
        } else if (object2 instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                collection.add(v1 != null ? StatisticsEventEscaper.escapeEventDataValue(v1) : it);
            }
            object = (List)destination$iv$iv;
        } else if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object entryKey = entry.getKey();
                Object entryValue = entry.getValue();
                Object newKey = entryKey instanceof String ? StatisticsEventEscaper.escapeFieldName((String)entryKey) : entryKey;
                Object v = entryValue;
                Object newValue = v != null ? StatisticsEventEscaper.escapeEventDataValue(v) : entryValue;
                entry = TuplesKt.to(newKey, (Object)newValue);
                map.put(entry.getFirst(), entry.getSecond());
            }
            object = destination$iv$iv2;
        } else {
            object = value;
        }
        return object;
    }

    private final String escapeInternal(String str, String toReplace, boolean allowSpaces) {
        return this.containsSystemSymbols(str, toReplace) ? this.replace(str, toReplace, allowSpaces) : str;
    }

    private final String replace(String value, String toReplace, boolean allowSpaces) {
        StringBuilder out = new StringBuilder();
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (!this.isAscii(c)) {
                out.append("?");
                continue;
            }
            if (this.isWhiteSpaceToReplace(c)) {
                out.append(allowSpaces ? " " : "_");
                continue;
            }
            if (this.isSymbolToReplace(c, toReplace)) {
                out.append("_");
                continue;
            }
            if (this.isProhibitedSymbol(c)) continue;
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    private final boolean containsSystemSymbols(String value, String toReplace) {
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (!this.isAscii(c)) {
                return true;
            }
            if (this.isWhiteSpaceToReplace(c)) {
                return true;
            }
            if (this.isSymbolToReplace(c, toReplace)) {
                return true;
            }
            if (!this.isProhibitedSymbol(c)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private final boolean isSymbolToReplace(char c, String toReplace) {
        return toReplace != null && this.containsChar(toReplace, c) ? true : this.isAsciiControl(c);
    }

    public final boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private final boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private final boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private final boolean containsChar(String str, char c) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (str.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new StatisticsEventEscaper();
        ValidationResultType[] $this$map$iv = ValidationResultType.values();
        boolean $i$f$map = false;
        ValidationResultType[] validationResultTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDescription());
        }
        VALIDATION_RESULT_TYPES = CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

