/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.EventDataValidationError;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventGroupRules {
    public static final EventGroupRules EMPTY = new EventGroupRules(Collections.emptySet(), Collections.emptyMap(), EventGroupContextData.EMPTY, new ValidationSimpleRuleFactory(ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER), Collections.emptyList());
    private static final Set<String> VALIDATION_TYPES = Arrays.stream(ValidationResultType.values()).map(ValidationResultType::getDescription).collect(Collectors.toSet());
    private static final FUSRule[] ALWAYS_TRUE_RULES = new FUSRule[]{FUSRule.TRUE};
    private final FUSRule[] eventIdRules;
    private final Map<String, FUSRule[]> eventDataRules;
    private final List<String> myExcludedFields;

    private EventGroupRules(@Nullable Set<String> eventIdRules, @Nullable Map<String, Set<String>> eventDataRules, @NotNull EventGroupContextData contextData, @NotNull ValidationSimpleRuleFactory factory, @NotNull List<String> excludedFields) {
        this.myExcludedFields = excludedFields;
        this.eventIdRules = factory.getRules(eventIdRules, contextData);
        if (eventDataRules != null && !eventDataRules.isEmpty()) {
            HashMap<String, FUSRule[]> rules = new HashMap<String, FUSRule[]>();
            for (Map.Entry<String, Set<String>> entry : eventDataRules.entrySet()) {
                if (this.myExcludedFields.contains(entry.getKey())) {
                    rules.put(entry.getKey(), ALWAYS_TRUE_RULES);
                    continue;
                }
                rules.put(entry.getKey(), factory.getRules(entry.getValue(), contextData));
            }
            this.eventDataRules = rules.size() == 1 ? EventGroupRules.toSingletonMap(rules) : Collections.unmodifiableMap(rules);
        } else {
            this.eventDataRules = Collections.emptyMap();
        }
    }

    @NotNull
    private static Map<String, FUSRule[]> toSingletonMap(Map<String, FUSRule[]> rules) {
        Map.Entry<String, FUSRule[]> entry = rules.entrySet().iterator().next();
        return Collections.singletonMap(entry.getKey(), entry.getValue());
    }

    public FUSRule[] getEventIdRules() {
        return this.eventIdRules;
    }

    public Map<String, FUSRule[]> getEventDataRules() {
        return this.eventDataRules;
    }

    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    public boolean areEventDataRulesDefined() {
        return this.eventDataRules.size() > 0;
    }

    public ValidationResultType validateEventId(@NotNull EventContext context) {
        ValidationResultType prevResult = null;
        if (VALIDATION_TYPES.contains(context.eventId)) {
            return ValidationResultType.ACCEPTED;
        }
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context.eventId, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    public EventDataField validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context) {
        return this.validateEventData(key, data, context, key, key);
    }

    private EventDataField validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context, @NotNull String fieldName, @NotNull String jsonPath) {
        if (data == null) {
            context.addError(new EventDataValidationError(ValidationResultType.REJECTED, jsonPath, "Data is null"));
            return new EventDataField(fieldName, ValidationResultType.REJECTED.getDescription());
        }
        if (data instanceof String && (ValidationResultType.VALIDATION_TYPES.contains(data) || EventLogSystemEvents.SYSTEM_EVENTS.contains(data))) {
            return new EventDataField(fieldName, data);
        }
        if (this.myExcludedFields.contains(key)) {
            return new EventDataField(fieldName, data);
        }
        if (data instanceof Map) {
            HashMap<String, Object> validatedData = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey instanceof String) {
                    EventDataField field = this.validateEventData(key + "." + entryKey, entry.getValue(), context, (String)entryKey, jsonPath + "." + entryKey);
                    validatedData.put(field.getName(), field.getValue());
                    continue;
                }
                context.addError(new EventDataValidationError(ValidationResultType.REJECTED, jsonPath + "." + entryKey.toString(), "Entry key should be String, actual=" + entryKey));
                validatedData.put((String)entryKey, ValidationResultType.REJECTED.getDescription());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && validatedData.keySet().stream().allMatch(value -> value instanceof String && ValidationResultType.UNDEFINED_RULE.getDescription().equals(value))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        if (data instanceof List) {
            ArrayList<Object> validatedData = new ArrayList<Object>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            List objects = (List)data;
            for (int i = 0; i < objects.size(); ++i) {
                Object value2 = objects.get(i);
                EventDataField validatedField = this.validateEventData(key, value2, context, fieldName, jsonPath + "[" + i + "]");
                validatedData.add(validatedField.getValue());
                fieldNames.add(validatedField.getName());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && fieldNames.stream().allMatch(value -> ValidationResultType.UNDEFINED_RULE.getDescription().equals(value))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        FUSRule[] rules = this.eventDataRules.get(key);
        if (rules == null || rules.length == 0) {
            context.addError(new EventDataValidationError(ValidationResultType.UNDEFINED_RULE, jsonPath, "Undefined rule"));
            return new EventDataField(ValidationResultType.UNDEFINED_RULE.getDescription(), ValidationResultType.UNDEFINED_RULE.getDescription());
        }
        return new EventDataField(fieldName, EventGroupRules.validateEventDataValue(data, context, rules, jsonPath));
    }

    private static Object validateEventDataValue(@NotNull Object data, @NotNull EventContext context, FUSRule @NotNull [] rules, @NotNull String jsonPath) {
        String value = data.toString();
        ValidationResultType resultType = EventGroupRules.acceptRule(value, context, rules);
        if (resultType == ValidationResultType.ACCEPTED) {
            return data;
        }
        context.addError(new EventDataValidationError(resultType, jsonPath, value));
        return resultType.getDescription();
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, @NotNull EventContext context, FUSRule ... rules) {
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @NotNull
    public static EventGroupRules create(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull ValidationSimpleRuleFactory factory, @NotNull List<String> excludedFields) {
        EventGroupRemoteDescriptors.GroupRemoteRule rules = group.rules;
        return rules == null ? EMPTY : new EventGroupRules(rules.event_id, rules.event_data, new EventGroupContextData(rules.enums, rules.regexps, globalRulesHolder), factory, excludedFields);
    }
}

