/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.SubCharBuffer;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerminalLine {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalLine.class);
    private TextEntries myTextEntries = new TextEntries();
    private boolean myWrapped = false;
    private final List<TerminalLineIntervalHighlighting> myCustomHighlightings = new ArrayList<TerminalLineIntervalHighlighting>();
    TerminalLine myTypeAheadLine;

    public TerminalLine() {
    }

    public TerminalLine(@NotNull TextEntry entry) {
        this.myTextEntries.add(entry);
    }

    public static TerminalLine createEmpty() {
        return new TerminalLine();
    }

    @NotNull
    public String getText() {
        StringBuilder result = new StringBuilder(this.myTextEntries.myLength);
        for (TextEntry textEntry : this.myTextEntries) {
            if (textEntry.getText().isNul()) break;
            result.append(textEntry.getText());
        }
        return result.toString();
    }

    @NotNull
    public TerminalLine copy() {
        TerminalLine result = new TerminalLine();
        for (TextEntry entry : this.myTextEntries) {
            result.myTextEntries.add(entry);
        }
        result.myWrapped = this.myWrapped;
        return result;
    }

    public char charAt(int x) {
        TerminalLine typeAheadLine = this.myTypeAheadLine;
        if (typeAheadLine != null) {
            return typeAheadLine.charAt(x);
        }
        String text = this.getText();
        return x < text.length() ? text.charAt(x) : (char)' ';
    }

    public boolean isWrapped() {
        return this.myWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.myWrapped = wrapped;
    }

    public synchronized void clear(@NotNull TextEntry filler) {
        this.myTextEntries.clear();
        this.myTextEntries.add(filler);
        this.setWrapped(false);
    }

    public void writeString(int x, @NotNull CharBuffer str, @NotNull TextStyle style) {
        this.writeCharacters(x, style, str);
    }

    public void insertString(int x, @NotNull CharBuffer str, @NotNull TextStyle style) {
        this.insertCharacters(x, style, str);
    }

    private synchronized void writeCharacters(int x, @NotNull TextStyle style, @NotNull CharBuffer characters) {
        int len = this.myTextEntries.length();
        if (x >= len) {
            if (x - len > 0) {
                this.myTextEntries.add(new TextEntry(TextStyle.EMPTY, new CharBuffer('\u0000', x - len)));
            }
            this.myTextEntries.add(new TextEntry(style, characters));
        } else {
            len = Math.max(len, x + characters.length());
            this.myTextEntries = TerminalLine.merge(x, characters, style, this.myTextEntries, len);
        }
    }

    private synchronized void insertCharacters(int x, @NotNull TextStyle style, @NotNull CharBuffer characters) {
        int i;
        int length = this.myTextEntries.length();
        if (x > length) {
            this.writeCharacters(x, style, characters);
            return;
        }
        Pair<char[], TextStyle[]> pair = TerminalLine.toBuf(this.myTextEntries, length + characters.length());
        for (i = length - 1; i >= x; --i) {
            ((char[])pair.first)[i + characters.length()] = ((char[])pair.first)[i];
            ((TextStyle[])pair.second)[i + characters.length()] = ((TextStyle[])pair.second)[i];
        }
        for (i = 0; i < characters.length(); ++i) {
            ((char[])pair.first)[i + x] = characters.charAt(i);
            ((TextStyle[])pair.second)[i + x] = style;
        }
        this.myTextEntries = TerminalLine.collectFromBuffer((char[])pair.first, (TextStyle[])pair.second);
    }

    private static TextEntries merge(int x, @NotNull CharBuffer str, @NotNull TextStyle style, @NotNull TextEntries entries, int lineLength) {
        Pair<char[], TextStyle[]> pair = TerminalLine.toBuf(entries, lineLength);
        for (int i = 0; i < str.length(); ++i) {
            ((char[])pair.first)[i + x] = str.charAt(i);
            ((TextStyle[])pair.second)[i + x] = style;
        }
        return TerminalLine.collectFromBuffer((char[])pair.first, (TextStyle[])pair.second);
    }

    private static Pair<char[], TextStyle[]> toBuf(TextEntries entries, int lineLength) {
        Pair<char[], TextStyle[]> pair = Pair.create(new char[lineLength], new TextStyle[lineLength]);
        int p = 0;
        for (TextEntry entry : entries) {
            for (int i = 0; i < entry.getLength(); ++i) {
                ((char[])pair.first)[p + i] = entry.getText().charAt(i);
                ((TextStyle[])pair.second)[p + i] = entry.getStyle();
            }
            p += entry.getLength();
        }
        return pair;
    }

    private static TextEntries collectFromBuffer(char[] buf, @NotNull TextStyle[] styles) {
        TextEntries result = new TextEntries();
        TextStyle curStyle = styles[0];
        int start = 0;
        for (int i = 1; i < buf.length; ++i) {
            if (styles[i] == curStyle) continue;
            result.add(new TextEntry(curStyle, new CharBuffer(buf, start, i - start)));
            curStyle = styles[i];
            start = i;
        }
        result.add(new TextEntry(curStyle, new CharBuffer(buf, start, buf.length - start)));
        return result;
    }

    public synchronized void deleteCharacters(int x) {
        this.deleteCharacters(x, TextStyle.EMPTY);
    }

    public synchronized void deleteCharacters(int x, @NotNull TextStyle style) {
        this.deleteCharacters(x, this.myTextEntries.length() - x, style);
        this.setWrapped(false);
    }

    public synchronized void deleteCharacters(int x, int count, @NotNull TextStyle style) {
        int p = 0;
        TextEntries newEntries = new TextEntries();
        int remaining = count;
        for (TextEntry entry : this.myTextEntries) {
            if (remaining == 0) {
                newEntries.add(entry);
                continue;
            }
            int len = entry.getLength();
            if (p + len <= x) {
                p += len;
                newEntries.add(entry);
                continue;
            }
            int dx = x - p;
            if (dx > 0) {
                newEntries.add(new TextEntry(entry.getStyle(), entry.getText().subBuffer(0, dx)));
                p = x;
            }
            if (dx + remaining < len) {
                newEntries.add(new TextEntry(entry.getStyle(), entry.getText().subBuffer(dx + remaining, len - (dx + remaining))));
                remaining = 0;
                continue;
            }
            remaining -= len - dx;
            p = x;
        }
        if (count > 0 && style != TextStyle.EMPTY) {
            newEntries.add(new TextEntry(style, new CharBuffer('\u0000', count)));
        }
        this.myTextEntries = newEntries;
    }

    public synchronized void insertBlankCharacters(int x, int count, int maxLen, @NotNull TextStyle style) {
        int len = this.myTextEntries.length();
        len = Math.min(len + count, maxLen);
        char[] buf = new char[len];
        TextStyle[] styles = new TextStyle[len];
        int p = 0;
        for (TextEntry entry : this.myTextEntries) {
            for (int i = 0; i < entry.getLength() && p < len; ++i) {
                if (p == x) {
                    for (int j = 0; j < count && p < len; ++p, ++j) {
                        buf[p] = 32;
                        styles[p] = style;
                    }
                }
                if (p >= len) continue;
                buf[p] = entry.getText().charAt(i);
                styles[p] = entry.getStyle();
                ++p;
            }
            if (p < len) continue;
            break;
        }
        while (p < x && p < len) {
            buf[p] = 32;
            styles[p] = TextStyle.EMPTY;
            ++p;
            ++p;
        }
        while (p < x + count && p < len) {
            buf[p] = 32;
            styles[p] = style;
            ++p;
            ++p;
        }
        this.myTextEntries = TerminalLine.collectFromBuffer(buf, styles);
    }

    public synchronized void clearArea(int leftX, int rightX, @NotNull TextStyle style) {
        if (rightX == -1) {
            rightX = Math.max(this.myTextEntries.length(), leftX);
        }
        this.writeCharacters(leftX, style, new CharBuffer(rightX >= this.myTextEntries.length() ? (char)'\u0000' : ' ', rightX - leftX));
    }

    @Nullable
    public synchronized TextStyle getStyleAt(int x) {
        int i = 0;
        for (TextEntry te : this.myTextEntries) {
            if (x >= i && x < i + te.getLength()) {
                return te.getStyle();
            }
            i += te.getLength();
        }
        return null;
    }

    public synchronized void process(int y, StyledTextConsumer consumer, int startRow) {
        int x = 0;
        int nulIndex = -1;
        TerminalLineIntervalHighlighting highlighting = this.myCustomHighlightings.stream().findFirst().orElse(null);
        TerminalLine typeAheadLine = this.myTypeAheadLine;
        TextEntries textEntries = typeAheadLine != null ? typeAheadLine.myTextEntries : this.myTextEntries;
        for (TextEntry te : textEntries) {
            if (te.getText().isNul()) {
                if (nulIndex < 0) {
                    nulIndex = x;
                }
                consumer.consumeNul(x, y, nulIndex, te.getStyle(), te.getText(), startRow);
            } else if (highlighting != null && te.getLength() > 0 && highlighting.intersectsWith(x, x + te.getLength())) {
                this.processIntersection(x, y, te, consumer, startRow, highlighting);
            } else {
                consumer.consume(x, y, te.getStyle(), te.getText(), startRow);
            }
            x += te.getLength();
        }
        consumer.consumeQueue(x, y, nulIndex < 0 ? x : nulIndex, startRow);
    }

    private void processIntersection(int startTextOffset, int y, @NotNull TextEntry te, @NotNull StyledTextConsumer consumer, int startRow, @NotNull TerminalLineIntervalHighlighting highlighting) {
        CharBuffer text = te.getText();
        int endTextOffset = startTextOffset + text.length();
        int[] offsets = new int[]{startTextOffset, endTextOffset, highlighting.getStartOffset(), highlighting.getEndOffset()};
        Arrays.sort(offsets);
        int startTextOffsetInd = Arrays.binarySearch(offsets, startTextOffset);
        int endTextOffsetInd = Arrays.binarySearch(offsets, endTextOffset);
        if (startTextOffsetInd < 0 || endTextOffsetInd < 0) {
            LOG.error("Cannot find " + Arrays.toString(new int[]{startTextOffset, endTextOffset}) + " in " + Arrays.toString(offsets) + ": " + Arrays.toString(new int[]{startTextOffsetInd, endTextOffsetInd}));
            consumer.consume(startTextOffset, y, te.getStyle(), text, startRow);
            return;
        }
        for (int i = startTextOffsetInd; i < endTextOffsetInd; ++i) {
            int length = offsets[i + 1] - offsets[i];
            if (length == 0) continue;
            SubCharBuffer subText = new SubCharBuffer(text, offsets[i] - startTextOffset, length);
            if (highlighting.intersectsWith(offsets[i], offsets[i + 1])) {
                consumer.consume(offsets[i], y, highlighting.mergeWith(te.getStyle()), subText, startRow);
                continue;
            }
            consumer.consume(offsets[i], y, te.getStyle(), subText, startRow);
        }
    }

    public synchronized boolean isNul() {
        for (TextEntry e : this.myTextEntries) {
            if (e.isNul()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (TextEntry e : this.myTextEntries) {
            if (e.isNul() || e.getLength() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNulOrEmpty() {
        return this.isNul() || this.isEmpty();
    }

    void forEachEntry(@NotNull Consumer<TextEntry> action) {
        this.myTextEntries.forEach(action);
    }

    @TestOnly
    public List<TextEntry> getEntries() {
        return Collections.unmodifiableList(this.myTextEntries.entries());
    }

    void appendEntry(@NotNull TextEntry entry) {
        this.myTextEntries.add(entry);
    }

    @NotNull
    public synchronized TerminalLineIntervalHighlighting addCustomHighlighting(int startOffset, int length, @NotNull TextStyle textStyle) {
        TerminalLineIntervalHighlighting highlighting = new TerminalLineIntervalHighlighting(this, startOffset, length, textStyle){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doDispose() {
                TerminalLine terminalLine = TerminalLine.this;
                synchronized (terminalLine) {
                    TerminalLine.this.myCustomHighlightings.remove(this);
                }
            }
        };
        this.myCustomHighlightings.add(highlighting);
        return highlighting;
    }

    public String toString() {
        return this.myTextEntries.length() + " chars, " + (this.myWrapped ? "wrapped, " : "") + this.myTextEntries.myTextEntries.size() + " entries: " + this.myTextEntries.myTextEntries.stream().map(entry -> entry.getText().toString()).collect(Collectors.joining("|"));
    }

    private static class TextEntries
    implements Iterable<TextEntry> {
        private final List<TextEntry> myTextEntries = new ArrayList<TextEntry>();
        private int myLength = 0;

        private TextEntries() {
        }

        public void add(TextEntry entry) {
            if (!entry.getText().isNul()) {
                for (TextEntry t : this.myTextEntries) {
                    if (!t.getText().isNul()) continue;
                    t.getText().unNullify();
                }
            }
            this.myTextEntries.add(entry);
            this.myLength += entry.getLength();
        }

        private List<TextEntry> entries() {
            return this.myTextEntries;
        }

        @Override
        @NotNull
        public Iterator<TextEntry> iterator() {
            return this.myTextEntries.iterator();
        }

        public int length() {
            return this.myLength;
        }

        public void clear() {
            this.myTextEntries.clear();
            this.myLength = 0;
        }
    }

    public static class TextEntry {
        private final TextStyle myStyle;
        private final CharBuffer myText;

        public TextEntry(@NotNull TextStyle style, @NotNull CharBuffer text) {
            this.myStyle = style;
            this.myText = text.clone();
        }

        public TextStyle getStyle() {
            return this.myStyle;
        }

        public CharBuffer getText() {
            return this.myText;
        }

        public int getLength() {
            return this.myText.length();
        }

        public boolean isNul() {
            return this.myText.isNul();
        }

        public String toString() {
            return this.myText.length() + " chars, style: " + this.myStyle + ", text: " + this.myText;
        }
    }
}

