/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultArtifactIdentifier
implements ArtifactIdentifier {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final IvyArtifactName name;

    public DefaultArtifactIdentifier(ModuleVersionIdentifier moduleVersionIdentifier, String name, String type, @Nullable String extension, @Nullable String classifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.name = new DefaultIvyArtifactName(name, type, extension, classifier);
    }

    public DefaultArtifactIdentifier(DefaultModuleComponentArtifactIdentifier id) {
        this.moduleVersionIdentifier = DefaultModuleVersionIdentifier.newId(id.getComponentIdentifier());
        this.name = id.getName();
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionIdentifier() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public String getType() {
        return this.name.getType();
    }

    @Override
    @Nullable
    public String getExtension() {
        return this.name.getExtension();
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.name.getClassifier();
    }

    public String toString() {
        return String.format("module: %s, name: %s", this.moduleVersionIdentifier, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultArtifactIdentifier)) {
            return false;
        }
        DefaultArtifactIdentifier that = (DefaultArtifactIdentifier)o;
        if (!Objects.equals(this.moduleVersionIdentifier, that.moduleVersionIdentifier)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result2 = this.moduleVersionIdentifier != null ? this.moduleVersionIdentifier.hashCode() : 0;
        result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
        return result2;
    }
}

