/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Serializer;

public class ReadOnlyArtifactCacheLockingAccessCoordinator
implements ArtifactCacheLockingAccessCoordinator,
Closeable {
    private static final Logger LOGGER = Logging.getLogger(ReadOnlyArtifactCacheLockingAccessCoordinator.class);
    private final PersistentCache cache;

    public ReadOnlyArtifactCacheLockingAccessCoordinator(UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, ArtifactCacheMetadata cacheMetaData) {
        this.cache = unscopedCacheBuilderFactory.cache(cacheMetaData.getCacheDir()).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("read only artifact cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.cache.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    @Override
    public <T> T useCache(Factory<? extends T> action) {
        return this.cache.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> IndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        IndexedCacheParameters<K, V> parameters = IndexedCacheParameters.of(cacheFileInMetaDataStore, keySerializer, valueSerializer);
        if (this.cache.indexedCacheExists(parameters)) {
            return new TransparentCacheLockingIndexedCache(new FailSafeIndexedCache(this.cache.createIndexedCache(parameters)));
        }
        return new EmptyIndexedCache();
    }

    private class TransparentCacheLockingIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private final IndexedCache<K, V> indexedCache;

        public TransparentCacheLockingIndexedCache(IndexedCache<K, V> indexedCache) {
            this.indexedCache = indexedCache;
        }

        @Override
        @Nullable
        public V getIfPresent(K key) {
            return (V)ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.getIfPresent(key));
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.get(key, producer));
        }

        @Override
        public void put(K key, V value) {
            ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.put(key, value));
        }

        @Override
        public void remove(K key) {
            ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.remove(key));
        }
    }

    private static class FailSafeIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private final IndexedCache<K, V> delegate;
        private boolean failed;

        private FailSafeIndexedCache(IndexedCache<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public V getIfPresent(K key) {
            return (V)this.failSafe(() -> this.delegate.getIfPresent(key));
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)this.failSafe(() -> this.delegate.get(key, producer));
        }

        @Override
        public void put(K key, V value) {
        }

        @Override
        public void remove(K key) {
        }

        private <T> T failSafe(Factory<T> operation) {
            if (this.failed) {
                return null;
            }
            try {
                return operation.create();
            }
            catch (Exception ex) {
                this.failed = true;
                LOGGER.debug("Error accessing read-only cache", ex);
                return null;
            }
        }
    }

    private static class EmptyIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private EmptyIndexedCache() {
        }

        @Override
        @Nullable
        public V getIfPresent(K key) {
            return null;
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> producer) {
            return producer.apply(key);
        }

        @Override
        public void put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(K key) {
            throw new UnsupportedOperationException();
        }
    }
}

