/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.file.FileContents;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.provider.CredentialsProviderFactory;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.internal.provider.sources.EnvironmentVariableValueSource;
import org.gradle.api.internal.provider.sources.EnvironmentVariablesPrefixedByValueSource;
import org.gradle.api.internal.provider.sources.FileBytesValueSource;
import org.gradle.api.internal.provider.sources.FileContentValueSource;
import org.gradle.api.internal.provider.sources.FileTextValueSource;
import org.gradle.api.internal.provider.sources.GradlePropertiesPrefixedByValueSource;
import org.gradle.api.internal.provider.sources.GradlePropertyValueSource;
import org.gradle.api.internal.provider.sources.SystemPropertiesPrefixedByValueSource;
import org.gradle.api.internal.provider.sources.SystemPropertyValueSource;
import org.gradle.api.internal.provider.sources.process.DefaultExecOutput;
import org.gradle.api.internal.provider.sources.process.ProcessOutputProviderFactory;
import org.gradle.api.internal.provider.sources.process.ProcessOutputValueSource;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.internal.event.ListenerManager;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;

public class DefaultProviderFactory
implements ProviderFactory {
    @Nullable
    private final ValueSourceProviderFactory valueSourceProviderFactory;
    @Nullable
    private final ProcessOutputProviderFactory processOutputProviderFactory;
    private final CredentialsProviderFactory credentialsProviderFactory;

    public DefaultProviderFactory() {
        this(null, null, null);
    }

    public DefaultProviderFactory(@Nullable ValueSourceProviderFactory valueSourceProviderFactory, @Nullable ProcessOutputProviderFactory processOutputProviderFactory, @Nullable ListenerManager listenerManager) {
        this.valueSourceProviderFactory = valueSourceProviderFactory;
        this.processOutputProviderFactory = processOutputProviderFactory;
        this.credentialsProviderFactory = new CredentialsProviderFactory(this);
        if (listenerManager != null) {
            listenerManager.addListener(this.credentialsProviderFactory);
        }
    }

    @Override
    public <T> Provider<T> provider(Callable<? extends T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return new DefaultProvider<T>(value);
    }

    @Override
    public Provider<String> environmentVariable(String variableName) {
        return this.environmentVariable(Providers.of(variableName));
    }

    @Override
    public Provider<String> environmentVariable(Provider<String> variableName) {
        return this.of(EnvironmentVariableValueSource.class, spec -> ((EnvironmentVariableValueSource.Parameters)spec.getParameters()).getVariableName().set(variableName));
    }

    @Override
    public Provider<Map<String, String>> environmentVariablesPrefixedBy(String variableNamePrefix) {
        return this.environmentVariablesPrefixedBy(Providers.of(variableNamePrefix));
    }

    @Override
    public Provider<Map<String, String>> environmentVariablesPrefixedBy(Provider<String> variableNamePrefix) {
        return this.of(EnvironmentVariablesPrefixedByValueSource.class, spec -> ((EnvironmentVariablesPrefixedByValueSource.Parameters)spec.getParameters()).getPrefix().set(variableNamePrefix));
    }

    @Override
    public Provider<String> systemProperty(String propertyName) {
        return this.systemProperty(Providers.of(propertyName));
    }

    @Override
    public Provider<String> systemProperty(Provider<String> propertyName) {
        return this.of(SystemPropertyValueSource.class, spec -> ((SystemPropertyValueSource.Parameters)spec.getParameters()).getPropertyName().set(propertyName));
    }

    @Override
    public Provider<Map<String, String>> systemPropertiesPrefixedBy(String variableNamePrefix) {
        return this.systemPropertiesPrefixedBy(Providers.of(variableNamePrefix));
    }

    @Override
    public Provider<Map<String, String>> systemPropertiesPrefixedBy(Provider<String> variableNamePrefix) {
        return this.of(SystemPropertiesPrefixedByValueSource.class, spec -> ((SystemPropertiesPrefixedByValueSource.Parameters)spec.getParameters()).getPrefix().set(variableNamePrefix));
    }

    @Override
    public Provider<String> gradleProperty(String propertyName) {
        return this.gradleProperty(Providers.of(propertyName));
    }

    @Override
    public Provider<String> gradleProperty(Provider<String> propertyName) {
        return this.of(GradlePropertyValueSource.class, spec -> ((GradlePropertyValueSource.Parameters)spec.getParameters()).getPropertyName().set(propertyName));
    }

    @Override
    public Provider<Map<String, String>> gradlePropertiesPrefixedBy(String variableNamePrefix) {
        return this.gradlePropertiesPrefixedBy(Providers.of(variableNamePrefix));
    }

    @Override
    public Provider<Map<String, String>> gradlePropertiesPrefixedBy(Provider<String> variableNamePrefix) {
        return this.of(GradlePropertiesPrefixedByValueSource.class, spec -> ((GradlePropertiesPrefixedByValueSource.Parameters)spec.getParameters()).getPrefix().set(variableNamePrefix));
    }

    @Override
    public FileContents fileContents(RegularFile file) {
        return this.fileContents((RegularFileProperty property2) -> property2.set(file));
    }

    @Override
    public FileContents fileContents(Provider<RegularFile> file) {
        return this.fileContents((RegularFileProperty property2) -> property2.set(file));
    }

    private FileContents fileContents(final Action<RegularFileProperty> setFileProperty) {
        return new FileContents(){

            @Override
            public Provider<String> getAsText() {
                return DefaultProviderFactory.this.of(FileTextValueSource.class, spec -> setFileProperty.execute(((FileContentValueSource.Parameters)spec.getParameters()).getFile()));
            }

            @Override
            public Provider<byte[]> getAsBytes() {
                return DefaultProviderFactory.this.of(FileBytesValueSource.class, spec -> setFileProperty.execute(((FileContentValueSource.Parameters)spec.getParameters()).getFile()));
            }
        };
    }

    @Override
    public ExecOutput exec(Action<? super ExecSpec> action) {
        if (this.processOutputProviderFactory == null) {
            throw new UnsupportedOperationException();
        }
        return new DefaultExecOutput(this.of(ProcessOutputValueSource.class, spec -> this.processOutputProviderFactory.configureParametersForExec((ProcessOutputValueSource.Parameters)spec.getParameters(), action)));
    }

    @Override
    public ExecOutput javaexec(Action<? super JavaExecSpec> action) {
        if (this.processOutputProviderFactory == null) {
            throw new UnsupportedOperationException();
        }
        return new DefaultExecOutput(this.of(ProcessOutputValueSource.class, spec -> this.processOutputProviderFactory.configureParametersForJavaExec((ProcessOutputValueSource.Parameters)spec.getParameters(), action)));
    }

    @Override
    public <T, P extends ValueSourceParameters> Provider<T> of(Class<? extends ValueSource<T, P>> valueSourceType, Action<? super ValueSourceSpec<P>> configuration) {
        if (this.valueSourceProviderFactory == null) {
            throw new UnsupportedOperationException();
        }
        return this.valueSourceProviderFactory.createProviderOf(valueSourceType, configuration);
    }

    @Override
    public <T extends Credentials> Provider<T> credentials(Class<T> credentialsType, String identity) {
        return this.credentialsProviderFactory.provide(credentialsType, identity);
    }

    @Override
    public <T extends Credentials> Provider<T> credentials(Class<T> credentialsType, Provider<String> identity) {
        return this.credentialsProviderFactory.provide(credentialsType, identity);
    }

    @Override
    public <A, B, R> Provider<R> zip(Provider<A> left, Provider<B> right, BiFunction<? super A, ? super B, ? extends R> combiner) {
        return left.zip(right, combiner);
    }
}

