/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.BaseFilePropertyVisitState;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertySpec;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.snapshot.DirectorySnapshot;

public class SnapshotTaskInputsResultFilePropertyVisitState
extends BaseFilePropertyVisitState
implements SnapshotTaskInputsBuildOperationType.Result.VisitState {
    private static final Map<FileNormalizer, String> FINGERPRINTING_STRATEGIES_BY_NORMALIZER = ImmutableMap.builder().put((Object)InputNormalizer.RUNTIME_CLASSPATH, (Object)"CLASSPATH").put((Object)InputNormalizer.COMPILE_CLASSPATH, (Object)"COMPILE_CLASSPATH").put((Object)InputNormalizer.ABSOLUTE_PATH, (Object)"ABSOLUTE_PATH").put((Object)InputNormalizer.RELATIVE_PATH, (Object)"RELATIVE_PATH").put((Object)InputNormalizer.NAME_ONLY, (Object)"NAME_ONLY").put((Object)InputNormalizer.IGNORE_PATH, (Object)"IGNORED_PATH").build();
    private final SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor;

    public static void visitInputFileProperties(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor, Set<InputFilePropertySpec> inputFilePropertySpecs) {
        ImmutableMap propertySpecsByName = Maps.uniqueIndex(inputFilePropertySpecs, PropertySpec::getPropertyName);
        SnapshotTaskInputsResultFilePropertyVisitState state = new SnapshotTaskInputsResultFilePropertyVisitState(visitor, (Map<String, InputFilePropertySpec>)propertySpecsByName);
        for (Map.Entry entry : inputFileProperties.entrySet()) {
            CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)entry.getValue();
            state.propertyName = (String)entry.getKey();
            state.propertyHash = fingerprint.getHash();
            state.fingerprints = fingerprint.getFingerprints();
            visitor.preProperty(state);
            fingerprint.getSnapshot().accept(state);
            visitor.postProperty();
        }
    }

    private SnapshotTaskInputsResultFilePropertyVisitState(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor, Map<String, InputFilePropertySpec> propertySpecsByName) {
        super(propertySpecsByName);
        this.visitor = visitor;
    }

    @Override
    protected void preRoot() {
        this.visitor.preRoot(this);
    }

    @Override
    protected void postRoot() {
        this.visitor.postRoot();
    }

    @Override
    protected void preDirectory() {
        this.visitor.preDirectory(this);
    }

    @Override
    protected void preUnvisitedDirectory(DirectorySnapshot unvisited) {
        this.visitor.preDirectory(new TaskDirectoryVisitState(unvisited, this));
    }

    @Override
    protected void postDirectory() {
        this.visitor.postDirectory();
    }

    @Override
    protected void file() {
        this.visitor.file(this);
    }

    @Override
    @Deprecated
    public String getPropertyNormalizationStrategyName() {
        InputFilePropertySpec propertySpec = this.propertySpec(this.propertyName);
        FileNormalizer normalizer = propertySpec.getNormalizer();
        String normalizationStrategy = FINGERPRINTING_STRATEGIES_BY_NORMALIZER.get(normalizer);
        if (normalizationStrategy == null) {
            throw new IllegalStateException("No strategy name for " + normalizer);
        }
        return normalizationStrategy;
    }

    private static class TaskDirectoryVisitState
    extends BaseFilePropertyVisitState.DirectoryVisitState<SnapshotTaskInputsBuildOperationType.Result.VisitState>
    implements SnapshotTaskInputsBuildOperationType.Result.VisitState {
        public TaskDirectoryVisitState(DirectorySnapshot unvisited, SnapshotTaskInputsBuildOperationType.Result.VisitState delegate) {
            super(unvisited, delegate);
        }

        @Override
        public String getPropertyNormalizationStrategyName() {
            return ((SnapshotTaskInputsBuildOperationType.Result.VisitState)this.delegate).getPropertyNormalizationStrategyName();
        }
    }
}

