/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.plugins;

import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.DefaultPublicationContainer;
import org.gradle.api.publish.internal.DefaultPublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.plugins.PublishingPluginRules;
import org.gradle.internal.Cast;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;

public abstract class PublishingPlugin
implements Plugin<Project> {
    public static final String PUBLISH_TASK_GROUP = "publishing";
    public static final String PUBLISH_LIFECYCLE_TASK_NAME = "publish";
    private static final String VALID_NAME_REGEX = "[A-Za-z0-9_\\-.]+";
    private final Instantiator instantiator;
    private final ArtifactPublicationServices publicationServices;
    private final ProjectPublicationRegistry projectPublicationRegistry;
    private final CollectionCallbackActionDecorator collectionCallbackActionDecorator;

    @Inject
    public PublishingPlugin(ArtifactPublicationServices publicationServices, Instantiator instantiator2, ProjectPublicationRegistry projectPublicationRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.publicationServices = publicationServices;
        this.instantiator = instantiator2;
        this.projectPublicationRegistry = projectPublicationRegistry;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    @Override
    public void apply(Project project) {
        RepositoryHandler repositories = this.publicationServices.createRepositoryHandler();
        PublicationContainer publications = this.instantiator.newInstance(DefaultPublicationContainer.class, this.instantiator, this.collectionCallbackActionDecorator);
        PublishingExtension extension = project.getExtensions().create(PublishingExtension.class, PUBLISH_TASK_GROUP, DefaultPublishingExtension.class, repositories, publications);
        project.getTasks().register(PUBLISH_LIFECYCLE_TASK_NAME, task -> {
            task.setDescription("Publishes all publications produced by this project.");
            task.setGroup(PUBLISH_TASK_GROUP);
        });
        extension.getPublications().all(publication -> {
            PublicationInternal internalPublication = (PublicationInternal)Cast.uncheckedNonnullCast(publication);
            ProjectInternal projectInternal = (ProjectInternal)project;
            this.projectPublicationRegistry.registerPublication(projectInternal, internalPublication);
        });
        this.bridgeToSoftwareModelIfNeeded((ProjectInternal)project);
        this.validatePublishingModelWhenComplete(project, extension);
    }

    private void validatePublishingModelWhenComplete(Project project, PublishingExtension extension) {
        project.afterEvaluate(projectAfterEvaluate -> {
            for (ArtifactRepository repository : extension.getRepositories()) {
                String repositoryName = repository.getName();
                if (repositoryName.matches(VALID_NAME_REGEX)) continue;
                throw new InvalidUserDataException("Repository name '" + repositoryName + "' is not valid for publication. Must match regex " + VALID_NAME_REGEX + ".");
            }
            for (Publication publication : extension.getPublications()) {
                String publicationName = publication.getName();
                if (publicationName.matches(VALID_NAME_REGEX)) continue;
                throw new InvalidUserDataException("Publication name '" + publicationName + "' is not valid for publication. Must match regex " + VALID_NAME_REGEX + ".");
            }
        });
    }

    private void bridgeToSoftwareModelIfNeeded(ProjectInternal project) {
        project.addRuleBasedPluginListener(new RuleBasedPluginListener(){

            @Override
            public void prepareForRuleBasedPlugins(Project project) {
                project.getPluginManager().apply(PublishingPluginRules.class);
            }
        });
    }
}

