/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.CapabilitiesMetadataInternal;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.Cast;
import org.gradle.internal.component.SelectionFailureHandler;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.DescriberSelector;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantSelectionResult;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class AttributeMatchingConfigurationSelector {
    private final SelectionFailureHandler failureProcessor;

    public AttributeMatchingConfigurationSelector(SelectionFailureHandler failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public SelectionFailureHandler getFailureProcessor() {
        return this.failureProcessor;
    }

    public VariantSelectionResult selectVariantsUsingAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        return this.selectVariantsUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, AttributeMatchingExplanationBuilder.logging());
    }

    private VariantSelectionResult selectVariantsUsingAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts, AttributeMatchingExplanationBuilder explanationBuilder) {
        AttributeDescriber describer;
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        GraphSelectionCandidates candidates = targetComponentState.getCandidatesForGraphVariantSelection();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(targetComponent.getAttributesSchema());
        boolean variantAware = candidates.isUseVariants();
        if (!variantAware) {
            return this.selectDefaultConfiguration(consumerAttributes, consumerSchema, targetComponent, attributeMatcher, candidates);
        }
        List<? extends VariantGraphResolveState> allConsumableVariants = candidates.getVariants();
        ImmutableList<VariantGraphResolveState> variantsProvidingRequestedCapabilities = this.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, allConsumableVariants, true);
        if (variantsProvidingRequestedCapabilities.isEmpty()) {
            throw this.failureProcessor.noMatchingCapabilitiesFailure(targetComponent, explicitRequestedCapabilities, allConsumableVariants);
        }
        List<VariantGraphResolveState> matches = attributeMatcher.matches(variantsProvidingRequestedCapabilities, consumerAttributes, explanationBuilder);
        if (matches.size() > 1) {
            List<VariantGraphResolveState> sameClassifier;
            String classifier;
            Object strictlyMatchingCapabilities = this.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, matches, false);
            if (strictlyMatchingCapabilities.size() == 1) {
                return this.singleVariant(true, (List<VariantGraphResolveState>)strictlyMatchingCapabilities);
            }
            if (strictlyMatchingCapabilities.size() > 1 && (strictlyMatchingCapabilities = attributeMatcher.matches(strictlyMatchingCapabilities, consumerAttributes, explanationBuilder)).size() == 1) {
                return this.singleVariant(true, (List<VariantGraphResolveState>)strictlyMatchingCapabilities);
            }
            if (requestedArtifacts.size() == 1 && (classifier = requestedArtifacts.get(0).getClassifier()) != null && (sameClassifier = this.findVariantsProvidingExactlySameClassifier(matches, classifier)) != null && sameClassifier.size() == 1) {
                return this.singleVariant(true, sameClassifier);
            }
        }
        if (matches.size() == 1) {
            return this.singleVariant(true, matches);
        }
        if (!matches.isEmpty()) {
            describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
            if (explanationBuilder instanceof TraceDiscardedConfigurations) {
                Set discarded = (Set)Cast.uncheckedCast(((TraceDiscardedConfigurations)explanationBuilder).discarded);
                throw this.failureProcessor.ambiguousConfigurationSelectionFailure(describer, consumerAttributes, attributeMatcher, matches, targetComponent, true, discarded);
            }
            return this.selectVariantsUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, new TraceDiscardedConfigurations());
        }
        describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
        throw this.failureProcessor.noMatchingConfigurationSelectionFailure(describer, consumerAttributes, attributeMatcher, targetComponent, candidates);
    }

    private VariantSelectionResult selectDefaultConfiguration(ImmutableAttributes consumerAttributes, AttributesSchemaInternal consumerSchema, ComponentGraphResolveMetadata targetComponent, AttributeMatcher attributeMatcher, GraphSelectionCandidates candidates) {
        ConfigurationGraphResolveState fallbackConfiguration = candidates.getLegacyConfiguration();
        if (fallbackConfiguration != null && fallbackConfiguration.getMetadata().isCanBeConsumed() && attributeMatcher.isMatching(fallbackConfiguration.getAttributes(), consumerAttributes)) {
            return this.singleVariant(candidates.isUseVariants(), (List<VariantGraphResolveState>)ImmutableList.of((Object)fallbackConfiguration.asVariant()));
        }
        AttributeDescriber describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
        throw this.failureProcessor.noMatchingConfigurationSelectionFailure(describer, consumerAttributes, attributeMatcher, targetComponent, candidates);
    }

    @Nullable
    private List<VariantGraphResolveState> findVariantsProvidingExactlySameClassifier(List<VariantGraphResolveState> matches, String classifier) {
        ArrayList sameClassifier = null;
        for (VariantGraphResolveState match : matches) {
            ArtifactIdentifier artifactIdentifier;
            ComponentArtifactMetadata componentArtifactMetadata;
            List<? extends ComponentArtifactMetadata> artifacts2 = match.resolveArtifacts().getArtifacts();
            if (artifacts2.size() != 1 || !((componentArtifactMetadata = artifacts2.get(0)) instanceof ModuleComponentArtifactMetadata) || !classifier.equals((artifactIdentifier = ((ModuleComponentArtifactMetadata)componentArtifactMetadata).toArtifactIdentifier()).getClassifier())) continue;
            if (sameClassifier == null) {
                sameClassifier = Collections.singletonList(match);
                continue;
            }
            sameClassifier = Lists.newArrayList(sameClassifier);
            sameClassifier.add(match);
        }
        return sameClassifier;
    }

    private VariantSelectionResult singleVariant(boolean variantAware, List<VariantGraphResolveState> matches) {
        assert (matches.size() == 1);
        VariantGraphResolveState match = matches.get(0);
        VariantGraphResolveMetadata matchMetadata = matches.get(0).getMetadata();
        if (matchMetadata instanceof ConfigurationGraphResolveMetadata && ((ConfigurationGraphResolveMetadata)matchMetadata).isDeprecatedForConsumption()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration(matchMetadata.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
        return new VariantSelectionResult((List<? extends VariantGraphResolveState>)ImmutableList.of((Object)match), variantAware);
    }

    private ImmutableList<VariantGraphResolveState> filterVariantsByRequestedCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, Collection<? extends VariantGraphResolveState> consumableVariants, boolean lenient) {
        if (consumableVariants.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)consumableVariants.size());
        boolean explicitlyRequested = !explicitRequestedCapabilities.isEmpty();
        ModuleIdentifier moduleId = targetComponent.getModuleVersionId().getModule();
        for (VariantGraphResolveState variantGraphResolveState : consumableVariants) {
            MatchResult result2;
            CapabilitiesMetadata capabilitiesMetadata = variantGraphResolveState.getCapabilities();
            List<? extends Capability> capabilities = capabilitiesMetadata.getCapabilities();
            if (explicitlyRequested) {
                MatchResult result22 = this.providesAllCapabilities(targetComponent, explicitRequestedCapabilities, capabilities);
            } else {
                result2 = this.containsImplicitCapability(capabilitiesMetadata, capabilities, moduleId.getGroup(), moduleId.getName());
            }
            if (!result2.matches || !lenient && result2 != MatchResult.EXACT_MATCH) continue;
            builder.add((Object)variantGraphResolveState);
        }
        return builder.build();
    }

    private MatchResult providesAllCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, List<? extends Capability> providerCapabilities) {
        if (providerCapabilities.isEmpty() && explicitRequestedCapabilities.size() == 1) {
            Capability requested = explicitRequestedCapabilities.iterator().next();
            ModuleVersionIdentifier moduleVersionIdentifier = targetComponent.getModuleVersionId();
            if (requested.getGroup().equals(moduleVersionIdentifier.getGroup()) && requested.getName().equals(moduleVersionIdentifier.getName())) {
                return MatchResult.EXACT_MATCH;
            }
        }
        for (Capability capability : explicitRequestedCapabilities) {
            String requestedGroup = capability.getGroup();
            String requestedName = capability.getName();
            boolean found = false;
            for (Capability capability2 : providerCapabilities) {
                if (!capability2.getGroup().equals(requestedGroup) || !capability2.getName().equals(requestedName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return MatchResult.NO_MATCH;
        }
        boolean exactMatch = explicitRequestedCapabilities.size() == providerCapabilities.size();
        return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
    }

    private MatchResult containsImplicitCapability(CapabilitiesMetadata capabilitiesMetadata, Collection<? extends Capability> capabilities, String group, String name) {
        if (this.fastContainsImplicitCapability((CapabilitiesMetadataInternal)capabilitiesMetadata, capabilities)) {
            return MatchResult.EXACT_MATCH;
        }
        for (Capability capability : capabilities) {
            Capability capability2 = this.unwrap(capability);
            if (!group.equals(capability2.getGroup()) || !name.equals(capability2.getName())) continue;
            boolean exactMatch = capabilities.size() == 1;
            return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
        }
        return MatchResult.NO_MATCH;
    }

    private boolean fastContainsImplicitCapability(CapabilitiesMetadataInternal capabilitiesMetadata, Collection<? extends Capability> capabilities) {
        return capabilities.isEmpty() || capabilitiesMetadata.isShadowedCapabilityOnly();
    }

    private Capability unwrap(Capability capability) {
        if (capability instanceof ShadowedCapability) {
            return ((ShadowedCapability)capability).getShadowedCapability();
        }
        return capability;
    }

    private static class TraceDiscardedConfigurations
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = Sets.newHashSet();

        private TraceDiscardedConfigurations() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }

    private static enum MatchResult {
        NO_MATCH(false),
        MATCHES_ALL(true),
        EXACT_MATCH(true);

        private final boolean matches;

        private MatchResult(boolean match) {
            this.matches = match;
        }
    }
}

