/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.time.Duration;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;

public class Result {
    private final Duration duration;
    private final Try<ExecutionEngine.Execution> execution;

    protected Result(Duration duration, Try<ExecutionEngine.Execution> execution) {
        this.duration = duration;
        this.execution = execution;
    }

    protected Result(Result parent) {
        this(parent.getDuration(), parent.getExecution());
    }

    public static Result failed(Throwable t, Duration duration) {
        return new Result(duration, Try.failure(t));
    }

    public static Result success(Duration duration, ExecutionEngine.Execution outcome) {
        return new Result(duration, Try.successful(outcome));
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Try<ExecutionEngine.Execution> getExecution() {
        return this.execution;
    }
}

