/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jansi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.nativeintegration.NativeIntegrationException;
import org.gradle.internal.nativeintegration.jansi.JansiStorage;
import org.gradle.internal.nativeintegration.jansi.JansiStorageLocator;

public class JansiBootPathConfigurer {
    private static final String JANSI_LIBRARY_PATH_SYS_PROP = "library.jansi.path";
    private final JansiStorageLocator locator = new JansiStorageLocator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(File storageDir) {
        JansiStorage jansiStorage = this.locator.locate(storageDir);
        if (jansiStorage != null) {
            File libFile = jansiStorage.getTargetLibFile();
            libFile.getParentFile().mkdirs();
            if (!libFile.exists()) {
                InputStream libraryInputStream = this.getClass().getResourceAsStream(jansiStorage.getJansiLibrary().getResourcePath());
                try {
                    if (libraryInputStream != null) {
                        this.copyLibrary(libraryInputStream, libFile);
                    }
                }
                finally {
                    IoActions.closeQuietly(libraryInputStream);
                }
            }
            System.setProperty(JANSI_LIBRARY_PATH_SYS_PROP, libFile.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLibrary(InputStream lib, File libFile) {
        try {
            try {
                FileOutputStream outputStream = new FileOutputStream(libFile);
                try {
                    IOUtils.copy((InputStream)lib, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                lib.close();
            }
        }
        catch (IOException e) {
            throw new NativeIntegrationException(String.format("Could not create Jansi native library '%s'.", libFile), e);
        }
    }
}

