/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.DefaultPluginId;
import org.gradle.util.internal.TextUtil;

public class TypeValidationProblemRenderer {
    public static String renderMinimalInformationAbout(Problem problem2) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem2, true);
    }

    public static String renderMinimalInformationAbout(Problem problem2, boolean renderDocLink) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem2, renderDocLink, true);
    }

    public static String renderMinimalInformationAbout(Problem problem2, boolean renderDocLink, boolean renderSolutions) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(TypeValidationProblemRenderer.introductionFor(problem2.getAdditionalData()) + TextUtil.endLineWithDot(problem2.getLabel()));
        Optional.ofNullable(problem2.getDetails()).ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot(problem2.getDetails())));
        });
        if (renderSolutions) {
            TypeValidationProblemRenderer.renderNewSolutions(formatter, problem2.getSolutions());
        }
        if (renderDocLink) {
            Optional.ofNullable(problem2.getDocumentationLink()).ifPresent(docLink -> {
                formatter.blankLine();
                formatter.node(new DocumentationRegistry().getDocumentationRecommendationFor("information", (DocLink)docLink));
            });
        }
        return formatter.toString();
    }

    private static void renderNewSolutions(TreeFormatter formatter, List<String> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot(possibleSolutions.get(0))));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot(solution))));
                formatter.endChildren();
            }
        }
    }

    public static void renderSolutionsWithNewProblemsApi(TreeFormatter formatter, List<String> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot(possibleSolutions.get(0))));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot(solution))));
                formatter.endChildren();
            }
        }
    }

    public static String convertToSingleLine(String message) {
        return message.replaceAll("(\\r?\\n *)+", ". ").replaceAll("[.]+", ".").replaceAll("[ ]+", " ").replaceAll(": ?[. ]", ": ");
    }

    public static String introductionFor(Map<String, String> additionalMetadata) {
        String property2;
        boolean typeRelevant;
        StringBuilder builder = new StringBuilder();
        String rootType = Optional.ofNullable(additionalMetadata.get("typeName")).filter(TypeValidationProblemRenderer::shouldRenderType).orElse(null);
        DefaultPluginId pluginId = Optional.ofNullable(additionalMetadata.get("pluginId")).map(DefaultPluginId::new).orElse(null);
        boolean bl = typeRelevant = rootType != null && !Boolean.parseBoolean(additionalMetadata.get("typeIsIrrelevantInErrorMessage"));
        if (typeRelevant) {
            if (pluginId != null) {
                builder.append("In plugin '").append(pluginId).append("' type '");
            } else {
                builder.append("Type '");
            }
            builder.append(rootType).append("' ");
        }
        if ((property2 = additionalMetadata.get("propertyName")) != null) {
            if (typeRelevant) {
                builder.append("property '");
            } else if (pluginId != null) {
                builder.append("In plugin '").append(pluginId).append("' property '");
            } else {
                builder.append("Property '");
            }
            Optional.ofNullable(additionalMetadata.get("parentPropertyName")).ifPresent(parentProperty -> {
                builder.append((String)parentProperty);
                builder.append('.');
            });
            builder.append(property2).append("' ");
        }
        return builder.toString();
    }

    private static boolean shouldRenderType(String className) {
        return !"org.gradle.api.DefaultTask".equals(className);
    }
}

