/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;

public class StringTextResource
implements TextResource {
    private static final HashCode SIGNATURE = Hashing.signature(StringTextResource.class);
    private final String displayName;
    private final CharSequence contents;
    private HashCode contentHash;

    public StringTextResource(String displayName, CharSequence contents) {
        this.displayName = displayName;
        this.contents = contents;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public DisplayName getLongDisplayName() {
        return Describables.of(this.displayName);
    }

    @Override
    public DisplayName getShortDisplayName() {
        return this.getLongDisplayName();
    }

    @Override
    public boolean isContentCached() {
        return true;
    }

    @Override
    public boolean getHasEmptyContent() {
        return this.contents.length() == 0;
    }

    @Override
    public Reader getAsReader() {
        return new StringReader(this.getText());
    }

    @Override
    public String getText() {
        return this.contents.toString();
    }

    @Override
    public HashCode getContentHash() throws ResourceException {
        if (this.contentHash == null) {
            PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
            hasher.putHash(SIGNATURE);
            hasher.putString(this.getText());
            this.contentHash = hasher.hash();
        }
        return this.contentHash;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public Charset getCharset() {
        return null;
    }

    @Override
    public ResourceLocation getLocation() {
        return new StringResourceLocation(this.displayName);
    }

    @Override
    public boolean getExists() {
        return true;
    }

    private static class StringResourceLocation
    implements ResourceLocation {
        private final String displayName;

        public StringResourceLocation(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @Nullable
        public File getFile() {
            return null;
        }

        @Override
        @Nullable
        public URI getURI() {
            return null;
        }
    }
}

