/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.cache.IndexedCache;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.resource.cached.CachedItem;
import org.gradle.internal.serialize.Serializer;

public abstract class AbstractCachedIndex<K, V extends CachedItem> {
    private final String persistentCacheName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator;
    private final FileAccessTracker fileAccessTracker;
    private IndexedCache<K, V> indexedCache;

    public AbstractCachedIndex(String persistentCacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer, ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator, FileAccessTracker fileAccessTracker2) {
        this.persistentCacheName = persistentCacheName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.cacheAccessCoordinator = cacheAccessCoordinator;
        this.fileAccessTracker = fileAccessTracker2;
    }

    private IndexedCache<K, V> getIndexedCache() {
        if (this.indexedCache == null) {
            this.indexedCache = this.initPersistentCache();
        }
        return this.indexedCache;
    }

    private IndexedCache<K, V> initPersistentCache() {
        return this.cacheAccessCoordinator.createCache(this.persistentCacheName, this.keySerializer, this.valueSerializer);
    }

    public V lookup(K key) {
        this.assertKeyNotNull(key);
        CachedItem result2 = this.cacheAccessCoordinator.useCache(() -> {
            CachedItem found = (CachedItem)this.getIndexedCache().getIfPresent(key);
            if (found == null) {
                return null;
            }
            if (found.isMissing() || found.getCachedFile().exists()) {
                return found;
            }
            this.clear(key);
            return null;
        });
        if (result2 != null && result2.getCachedFile() != null) {
            this.fileAccessTracker.markAccessed(result2.getCachedFile());
        }
        return (V)result2;
    }

    protected void storeInternal(K key, V entry) {
        this.cacheAccessCoordinator.useCache(() -> this.getIndexedCache().put(key, (CachedItem)entry));
    }

    protected void assertKeyNotNull(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
    }

    protected void assertArtifactFileNotNull(File artifactFile) {
        if (artifactFile == null) {
            throw new IllegalArgumentException("artifactFile cannot be null");
        }
    }

    public void clear(K key) {
        this.assertKeyNotNull(key);
        this.cacheAccessCoordinator.useCache(() -> this.getIndexedCache().remove(key));
    }
}

