/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.plugins;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.PublishableComponent;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.transform.UnzipTransform;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenPublicationCoordinates;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.language.ComponentWithBinaries;
import org.gradle.language.ComponentWithOutputs;
import org.gradle.language.ComponentWithTargetMachines;
import org.gradle.language.ProductionComponent;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithSharedLibrary;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithStaticLibrary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.internal.DefaultTargetMachineFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ExtractSymbols;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.StripSymbols;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public abstract class NativeBasePlugin
implements Plugin<Project> {
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public NativeBasePlugin(TargetMachineFactory targetMachineFactory) {
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        NativeBasePlugin.addTargetMachineFactoryAsExtension(project.getExtensions(), this.targetMachineFactory);
        TaskContainer tasks = project.getTasks();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        SoftwareComponentContainer components = project.getComponents();
        this.addLifecycleTasks(project, tasks, components);
        this.addTasksForComponentWithExecutable(tasks, buildDirectory, components);
        this.addTasksForComponentWithSharedLibrary(tasks, buildDirectory, components);
        this.addTasksForComponentWithStaticLibrary(tasks, buildDirectory, components);
        DependencyHandler dependencyHandler = project.getDependencies();
        ObjectFactory objects = project.getObjects();
        this.addHeaderZipTransform(dependencyHandler, objects);
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        project.getDependencies().getAttributesSchema().attribute(CppBinary.LINKAGE_ATTRIBUTE).getDisambiguationRules().add(LinkageSelectionRule.class);
        this.addOutgoingConfigurationForLinkUsage(components, configurations);
        this.addOutgoingConfigurationForRuntimeUsage(components, configurations);
        this.addPublicationsFromVariants(project, components);
    }

    private static void addTargetMachineFactoryAsExtension(ExtensionContainer extensions, TargetMachineFactory targetMachineFactory) {
        extensions.add(TargetMachineFactory.class, "machines", targetMachineFactory);
    }

    private void addLifecycleTasks(Project project, TaskContainer tasks, SoftwareComponentContainer components) {
        components.withType(ComponentWithBinaries.class, component -> {
            component.getBinaries().whenElementKnown(binary -> components.add(binary));
            if (component instanceof ProductionComponent) {
                component.getBinaries().whenElementFinalized(ComponentWithOutputs.class, binary -> {
                    FileCollection outputs = binary.getOutputs();
                    Names names = ((ComponentWithNames)((Object)binary)).getNames();
                    tasks.register(names.getTaskName("assemble"), task -> task.dependsOn(outputs));
                    if (binary == ((ProductionComponent)((Object)component)).getDevelopmentBinary().get()) {
                        tasks.named("assemble", task -> task.dependsOn(outputs));
                    }
                });
            }
            if (component instanceof ComponentWithTargetMachines) {
                ComponentWithTargetMachines componentWithTargetMachines = (ComponentWithTargetMachines)((Object)component);
                tasks.named("assemble", task -> task.dependsOn(() -> {
                    TargetMachine currentHost = ((DefaultTargetMachineFactory)this.targetMachineFactory).host();
                    boolean targetsCurrentMachine = ((Set)componentWithTargetMachines.getTargetMachines().get()).stream().anyMatch(targetMachine -> currentHost.getOperatingSystemFamily().equals(targetMachine.getOperatingSystemFamily()));
                    if (!targetsCurrentMachine) {
                        task.getLogger().warn("'" + component.getName() + "' component in project '" + project.getPath() + "' does not target this operating system.");
                    }
                    return Collections.emptyList();
                }));
            }
        });
    }

    private void addTasksForComponentWithExecutable(TaskContainer tasks, DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithExecutable.class, executable -> {
            Names names = executable.getNames();
            NativeToolChain toolChain = executable.getToolChain();
            NativePlatform targetPlatform = executable.getNativePlatform();
            PlatformToolProvider toolProvider = executable.getPlatformToolProvider();
            NamedDomainObjectProvider link = tasks.register(names.getTaskName("link"), LinkExecutable.class, task -> {
                task.source(executable.getObjects());
                task.lib(executable.getLinkLibraries());
                task.getLinkedFile().set(buildDirectory.file(executable.getBaseName().map(baseName -> toolProvider.getExecutableName("exe/" + names.getDirName() + baseName))));
                task.getTargetPlatform().set(targetPlatform);
                task.getToolChain().set(toolChain);
                task.getDebuggable().set(executable.isDebuggable());
            });
            executable.getLinkTask().set(link);
            executable.getDebuggerExecutableFile().set(link.flatMap(linkExecutable -> linkExecutable.getLinkedFile()));
            if (executable.isDebuggable() && executable.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                Provider<RegularFile> symbolLocation = buildDirectory.file(executable.getBaseName().map(baseName -> toolProvider.getExecutableSymbolFileName("exe/" + names.getDirName() + "stripped/" + baseName)));
                Provider<RegularFile> strippedLocation = buildDirectory.file(executable.getBaseName().map(baseName -> toolProvider.getExecutableName("exe/" + names.getDirName() + "stripped/" + baseName)));
                TaskProvider<StripSymbols> stripSymbols = this.stripSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, strippedLocation);
                executable.getExecutableFile().set(stripSymbols.flatMap(task -> task.getOutputFile()));
                TaskProvider<ExtractSymbols> extractSymbols = this.extractSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, symbolLocation);
                executable.getOutputs().from(extractSymbols.flatMap(task -> task.getSymbolFile()));
                executable.getExecutableFileProducer().set(stripSymbols);
            } else {
                executable.getExecutableFile().set(link.flatMap(task -> task.getLinkedFile()));
                executable.getExecutableFileProducer().set(link);
            }
            NamedDomainObjectProvider install = tasks.register(names.getTaskName("install"), InstallExecutable.class, task -> {
                task.getTargetPlatform().set(targetPlatform);
                task.getToolChain().set(toolChain);
                task.getInstallDirectory().set(buildDirectory.dir("install/" + names.getDirName()));
                task.getExecutableFile().set(executable.getExecutableFile());
                task.lib(executable.getRuntimeLibraries());
            });
            executable.getInstallTask().set(install);
            executable.getInstallDirectory().set(install.flatMap(task -> task.getInstallDirectory()));
            executable.getOutputs().from(executable.getInstallDirectory());
            executable.getDebuggerExecutableFile().set(install.flatMap(task -> task.getInstalledExecutable()));
        });
    }

    private void addTasksForComponentWithSharedLibrary(TaskContainer tasks, DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithSharedLibrary.class, library -> {
            Names names = library.getNames();
            NativePlatform targetPlatform = library.getNativePlatform();
            NativeToolChain toolChain = library.getToolChain();
            PlatformToolProvider toolProvider = library.getPlatformToolProvider();
            TaskProvider<StripSymbols> link = tasks.register(names.getTaskName("link"), LinkSharedLibrary.class, task -> {
                task.source(library.getObjects());
                task.lib(library.getLinkLibraries());
                task.getLinkedFile().set(buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getSharedLibraryName("lib/" + names.getDirName() + baseName))));
                if (!targetPlatform.getOperatingSystem().isMacOsX()) {
                    Provider<String> installName = task.getLinkedFile().getLocationOnly().map(linkedFile -> linkedFile.getAsFile().getName());
                    task.getInstallName().set(installName);
                }
                task.getTargetPlatform().set(targetPlatform);
                task.getToolChain().set(toolChain);
                task.getDebuggable().set(library.isDebuggable());
            });
            Provider linkFile = link.flatMap(task -> task.getLinkedFile());
            Provider runtimeFile = link.flatMap(task -> task.getLinkedFile());
            TaskProvider<StripSymbols> linkFileTask = link;
            if (toolProvider.producesImportLibrary()) {
                link.configure(linkSharedLibrary -> linkSharedLibrary.getImportLibrary().set(buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getImportLibraryName("lib/" + names.getDirName() + baseName)))));
                linkFile = link.flatMap(task -> task.getImportLibrary());
            }
            if (library.isDebuggable() && library.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                Provider<RegularFile> symbolLocation = buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getLibrarySymbolFileName("lib/" + names.getDirName() + "stripped/" + baseName)));
                Provider<RegularFile> strippedLocation = buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getSharedLibraryName("lib/" + names.getDirName() + "stripped/" + baseName)));
                TaskProvider<StripSymbols> stripSymbols = this.stripSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, strippedLocation);
                runtimeFile = stripSymbols.flatMap(task -> task.getOutputFile());
                linkFile = runtimeFile;
                TaskProvider<ExtractSymbols> extractSymbols = this.extractSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, symbolLocation);
                library.getOutputs().from(extractSymbols.flatMap(task -> task.getSymbolFile()));
                linkFileTask = stripSymbols;
            }
            library.getLinkTask().set(link);
            library.getLinkFile().set(linkFile);
            library.getLinkFileProducer().set(linkFileTask);
            library.getRuntimeFile().set(runtimeFile);
            library.getOutputs().from(library.getLinkFile());
            library.getOutputs().from(library.getRuntimeFile());
        });
    }

    private void addTasksForComponentWithStaticLibrary(TaskContainer tasks, DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithStaticLibrary.class, library -> {
            Names names = library.getNames();
            NamedDomainObjectProvider createTask = tasks.register(names.getTaskName("create"), CreateStaticLibrary.class, task -> {
                task.source(library.getObjects());
                PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                Provider<RegularFile> linktimeFile = buildDirectory.file(library.getBaseName().map(baseName -> toolProvider.getStaticLibraryName("lib/" + names.getDirName() + baseName)));
                task.getOutputFile().set(linktimeFile);
                task.getTargetPlatform().set(library.getNativePlatform());
                task.getToolChain().set(library.getToolChain());
            });
            library.getLinkFile().set(createTask.flatMap(task -> task.getBinaryFile()));
            library.getLinkFileProducer().set(createTask);
            library.getCreateTask().set(createTask);
            library.getOutputs().from(library.getLinkFile());
        });
    }

    private void addOutgoingConfigurationForLinkUsage(SoftwareComponentContainer components, RoleBasedConfigurationContainerInternal configurations) {
        components.withType(ConfigurableComponentWithLinkUsage.class, component -> {
            Names names = component.getNames();
            Configuration linkElements = configurations.migratingUnlocked(names.withSuffix("linkElements"), ConfigurationRolesForMigration.CONSUMABLE_DEPENDENCY_SCOPE_TO_CONSUMABLE);
            linkElements.extendsFrom(component.getImplementationDependencies());
            AttributeContainer attributes = component.getLinkAttributes();
            this.copyAttributesTo(attributes, linkElements);
            linkElements.getOutgoing().artifact(component.getLinkFile());
            component.getLinkElements().set(linkElements);
        });
    }

    private void addOutgoingConfigurationForRuntimeUsage(SoftwareComponentContainer components, RoleBasedConfigurationContainerInternal configurations) {
        components.withType(ConfigurableComponentWithRuntimeUsage.class, component -> {
            Names names = component.getNames();
            Configuration runtimeElements = configurations.migratingUnlocked(names.withSuffix("runtimeElements"), ConfigurationRolesForMigration.CONSUMABLE_DEPENDENCY_SCOPE_TO_CONSUMABLE);
            runtimeElements.extendsFrom(component.getImplementationDependencies());
            AttributeContainer attributes = component.getRuntimeAttributes();
            this.copyAttributesTo(attributes, runtimeElements);
            if (component.hasRuntimeFile()) {
                runtimeElements.getOutgoing().artifact(component.getRuntimeFile());
            }
            component.getRuntimeElements().set(runtimeElements);
        });
    }

    private void addPublicationsFromVariants(Project project, SoftwareComponentContainer components) {
        project.getPluginManager().withPlugin("maven-publish", plugin -> components.withType(PublicationAwareComponent.class, component -> project.getExtensions().configure(PublishingExtension.class, publishing -> {
            ComponentWithVariants mainVariant = component.getMainPublication();
            publishing.getPublications().create("main", MavenPublication.class, publication -> {
                MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                publicationInternal.getPom().getCoordinates().getArtifactId().set(component.getBaseName());
                publicationInternal.from(mainVariant);
                publicationInternal.publishWithOriginalFileName();
            });
            Set<? extends SoftwareComponent> variants = mainVariant.getVariants();
            if (variants instanceof DomainObjectSet) {
                ((DomainObjectSet)variants).all(child -> this.addPublicationFromVariant((SoftwareComponent)child, (PublishingExtension)publishing, project));
            } else {
                for (SoftwareComponent softwareComponent : variants) {
                    this.addPublicationFromVariant(softwareComponent, (PublishingExtension)publishing, project);
                }
            }
        })));
    }

    private void addPublicationFromVariant(SoftwareComponent child, PublishingExtension publishing, Project project) {
        if (child instanceof PublishableComponent) {
            publishing.getPublications().create(child.getName(), MavenPublication.class, publication -> {
                MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                this.fillInCoordinates(project, publicationInternal, (PublishableComponent)child);
                publicationInternal.from(child);
                publicationInternal.publishWithOriginalFileName();
            });
        }
    }

    private void fillInCoordinates(Project project, MavenPublicationInternal publication, PublishableComponent publishableComponent) {
        ModuleVersionIdentifier coordinates = publishableComponent.getCoordinates();
        MavenPublicationCoordinates pomCoordinates = publication.getPom().getCoordinates();
        pomCoordinates.getGroupId().set(project.provider(() -> coordinates.getGroup()));
        pomCoordinates.getArtifactId().set(project.provider(() -> coordinates.getName()));
        pomCoordinates.getVersion().set(project.provider(() -> coordinates.getVersion()));
    }

    private void copyAttributesTo(AttributeContainer attributes, Configuration linkElements) {
        for (Attribute<?> attribute : attributes.keySet()) {
            Object value = attributes.getAttribute(attribute);
            linkElements.getAttributes().attribute((Attribute)Cast.uncheckedCast(attribute), value);
        }
    }

    private TaskProvider<StripSymbols> stripSymbols(TaskProvider<? extends AbstractLinkTask> link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> strippedLocation) {
        return tasks.register(names.getTaskName("stripSymbols"), StripSymbols.class, stripSymbols -> {
            stripSymbols.getBinaryFile().set(link.flatMap(task -> task.getLinkedFile()));
            stripSymbols.getOutputFile().set(strippedLocation);
            stripSymbols.getTargetPlatform().set(currentPlatform);
            stripSymbols.getToolChain().set(toolChain);
        });
    }

    private TaskProvider<ExtractSymbols> extractSymbols(TaskProvider<? extends AbstractLinkTask> link, Names names, TaskContainer tasks, NativeToolChain toolChain, NativePlatform currentPlatform, Provider<RegularFile> symbolLocation) {
        return tasks.register(names.getTaskName("extractSymbols"), ExtractSymbols.class, extractSymbols -> {
            extractSymbols.getBinaryFile().set(link.flatMap(task -> task.getLinkedFile()));
            extractSymbols.getSymbolFile().set(symbolLocation);
            extractSymbols.getTargetPlatform().set(currentPlatform);
            extractSymbols.getToolChain().set(toolChain);
        });
    }

    private void addHeaderZipTransform(DependencyHandler dependencyHandler, ObjectFactory objects) {
        dependencyHandler.registerTransform(UnzipTransform.class, variantTransform -> {
            variantTransform.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, "zip");
            variantTransform.getFrom().attribute(Usage.USAGE_ATTRIBUTE, objects.named(Usage.class, "cplusplus-api"));
            variantTransform.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, "directory");
            variantTransform.getTo().attribute(Usage.USAGE_ATTRIBUTE, objects.named(Usage.class, "cplusplus-api"));
        });
    }

    static class LinkageSelectionRule
    implements AttributeDisambiguationRule<Linkage> {
        LinkageSelectionRule() {
        }

        @Override
        public void execute(MultipleCandidatesDetails<Linkage> details) {
            if (details.getCandidateValues().contains(Linkage.SHARED)) {
                details.closestMatch(Linkage.SHARED);
            }
        }
    }
}

