/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteName;
import org.gradle.api.attributes.TestSuiteTargetName;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JvmTestSuitePlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.JvmTestSuiteTarget;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.testing.jacoco.tasks.JacocoCoverageVerification;
import org.gradle.testing.jacoco.tasks.JacocoReport;

public abstract class JacocoPlugin
implements Plugin<Project> {
    public static final String DEFAULT_JACOCO_VERSION = "0.8.9";
    public static final String AGENT_CONFIGURATION_NAME = "jacocoAgent";
    public static final String ANT_CONFIGURATION_NAME = "jacocoAnt";
    public static final String PLUGIN_EXTENSION_NAME = "jacoco";
    private static final String COVERAGE_DATA_ELEMENTS_VARIANT_PREFIX = "coverageDataElementsFor";
    private final Instantiator instantiator;
    private ProjectInternal project;

    @Inject
    public JacocoPlugin(Instantiator instantiator2) {
        this.instantiator = instantiator2;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.project = (ProjectInternal)project;
        this.addJacocoConfigurations();
        JacocoAgentJar agent = this.instantiator.newInstance(JacocoAgentJar.class, this.project.getServices().get(FileOperations.class));
        JacocoPluginExtension extension = project.getExtensions().create(PLUGIN_EXTENSION_NAME, JacocoPluginExtension.class, project, agent);
        extension.setToolVersion(DEFAULT_JACOCO_VERSION);
        ReportingExtension reportingExtension = (ReportingExtension)project.getExtensions().getByName("reporting");
        extension.getReportsDirectory().convention(project.getLayout().dir(project.provider(() -> reportingExtension.file(PLUGIN_EXTENSION_NAME))));
        this.configureAgentDependencies(agent, extension);
        this.configureTaskClasspathDefaults(extension);
        this.applyToDefaultTasks(extension);
        this.configureJacocoReportsDefaults(extension);
        this.addDefaultReportAndCoverageVerificationTasks(extension);
        this.configureCoverageDataElementsVariants(project);
    }

    private void configureCoverageDataElementsVariants(Project project) {
        project.getPlugins().withType(JvmTestSuitePlugin.class, p -> {
            TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer<TestSuite> testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).configureEach(suite -> suite.getTargets().configureEach(target -> this.createCoverageDataVariant((ProjectInternal)project, (JvmTestSuite)suite, (JvmTestSuiteTarget)target)));
        });
    }

    private void createCoverageDataVariant(ProjectInternal project, JvmTestSuite suite, JvmTestSuiteTarget target) {
        Configuration variant = project.getConfigurations().migratingUnlocked(COVERAGE_DATA_ELEMENTS_VARIANT_PREFIX + StringUtils.capitalize((String)target.getName()), ConfigurationRolesForMigration.CONSUMABLE_DEPENDENCY_SCOPE_TO_CONSUMABLE);
        variant.setDescription("Binary data file containing results of Jacoco test coverage reporting for the " + suite.getName() + " Test Suite's " + target.getName() + " target.");
        variant.setVisible(false);
        ObjectFactory objects = project.getObjects();
        variant.attributes(attributes -> {
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.class, "verification"));
            attributes.attribute(TestSuiteName.TEST_SUITE_NAME_ATTRIBUTE, objects.named(TestSuiteName.class, suite.getName()));
            attributes.attribute(TestSuiteTargetName.TEST_SUITE_TARGET_NAME_ATTRIBUTE, objects.named(TestSuiteTargetName.class, target.getName()));
            attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, suite.getTestType().map(tt -> objects.named(TestSuiteType.class, (String)tt)));
            attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, objects.named(VerificationType.class, "jacoco-coverage"));
        });
        variant.getOutgoing().artifact(target.getTestTask().map(task -> task.getExtensions().getByType(JacocoTaskExtension.class).getDestinationFile()), artifact -> {
            artifact.setType("binary");
            artifact.builtBy(target.getTestTask());
        });
    }

    private void addJacocoConfigurations() {
        RoleBasedConfigurationContainerInternal configurations = this.project.getConfigurations();
        Configuration agentConf = configurations.resolvableDependencyScopeUnlocked(AGENT_CONFIGURATION_NAME);
        agentConf.setVisible(false);
        agentConf.setTransitive(true);
        agentConf.setDescription("The Jacoco agent to use to get coverage data.");
        Configuration antConf = configurations.resolvableDependencyScopeUnlocked(ANT_CONFIGURATION_NAME);
        antConf.setVisible(false);
        antConf.setTransitive(true);
        antConf.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
    }

    private void configureAgentDependencies(JacocoAgentJar jacocoAgentJar, JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(AGENT_CONFIGURATION_NAME);
        jacocoAgentJar.setAgentConf(config);
        config.defaultDependencies(dependencies -> dependencies.add(this.project.getDependencies().create("org.jacoco:org.jacoco.agent:" + extension.getToolVersion())));
    }

    private void configureTaskClasspathDefaults(JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(ANT_CONFIGURATION_NAME);
        this.project.getTasks().withType(JacocoBase.class).configureEach(task -> task.setJacocoClasspath(config));
        config.defaultDependencies(dependencies -> dependencies.add(this.project.getDependencies().create("org.jacoco:org.jacoco.ant:" + extension.getToolVersion())));
    }

    private void applyToDefaultTasks(JacocoPluginExtension extension) {
        this.project.getTasks().withType(Test.class).configureEach(extension::applyTo);
    }

    private void configureJacocoReportsDefaults(JacocoPluginExtension extension) {
        this.project.getTasks().withType(JacocoReport.class).configureEach(reportTask -> this.configureJacocoReportDefaults(extension, (JacocoReport)reportTask));
    }

    private void configureJacocoReportDefaults(JacocoPluginExtension extension, JacocoReport reportTask) {
        reportTask.getReports().all(SerializableLambdas.action(report2 -> report2.getRequired().convention(report2.getName().equals("html"))));
        DirectoryProperty reportsDir = extension.getReportsDirectory();
        reportTask.getReports().all(SerializableLambdas.action(report2 -> {
            if (report2.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                ((DirectoryReport)report2).getOutputLocation().convention(reportsDir.dir(reportTask.getName() + "/" + report2.getName()));
            } else {
                ((SingleFileReport)report2).getOutputLocation().convention(reportsDir.file(reportTask.getName() + "/" + reportTask.getName() + "." + report2.getName()));
            }
        }));
    }

    private void addDefaultReportAndCoverageVerificationTasks(JacocoPluginExtension extension) {
        this.project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            TestingExtension testing = this.project.getExtensions().getByType(TestingExtension.class);
            JvmTestSuite defaultTestSuite = (JvmTestSuite)testing.getSuites().withType(JvmTestSuite.class).getByName("test");
            defaultTestSuite.getTargets().configureEach(target -> {
                TaskProvider<Test> testTask = target.getTestTask();
                this.addDefaultReportTask(extension, testTask);
                this.addDefaultCoverageVerificationTask(testTask);
            });
        });
    }

    private void addDefaultReportTask(JacocoPluginExtension extension, TaskProvider<? extends Task> testTaskProvider) {
        String testTaskName = testTaskProvider.getName();
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskName) + "Report", JacocoReport.class, reportTask -> {
            reportTask.setGroup("verification");
            reportTask.setDescription(String.format("Generates code coverage report for the %s task.", testTaskName));
            reportTask.executionData((Task)testTaskProvider.get());
            reportTask.sourceSets((SourceSet)this.project.getExtensions().getByType(SourceSetContainer.class).getByName("main"));
            DirectoryProperty reportsDir = extension.getReportsDirectory();
            reportTask.getReports().all(SerializableLambdas.action(report2 -> {
                if (report2.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    ((DirectoryReport)report2).getOutputLocation().convention(reportsDir.dir(testTaskName + "/" + report2.getName()));
                } else {
                    ((SingleFileReport)report2).getOutputLocation().convention(reportsDir.file(testTaskName + "/" + reportTask.getName() + "." + report2.getName()));
                }
            }));
        });
    }

    private void addDefaultCoverageVerificationTask(TaskProvider<? extends Task> testTaskProvider) {
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskProvider.getName()) + "CoverageVerification", JacocoCoverageVerification.class, coverageVerificationTask -> {
            coverageVerificationTask.setGroup("verification");
            coverageVerificationTask.setDescription(String.format("Verifies code coverage metrics based on specified rules for the %s task.", testTaskProvider.getName()));
            coverageVerificationTask.executionData((Task)testTaskProvider.get());
            coverageVerificationTask.sourceSets((SourceSet)this.project.getExtensions().getByType(SourceSetContainer.class).getByName("main"));
        });
    }
}

