/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.tooling.IntermediateResultHandler;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.protocol.PhasedActionResultListener;

public class DefaultPhasedActionResultListener
implements PhasedActionResultListener {
    @Nullable
    private final IntermediateResultHandler<?> projectsLoadedHandler;
    @Nullable
    private final IntermediateResultHandler<?> buildFinishedHandler;

    public DefaultPhasedActionResultListener(@Nullable IntermediateResultHandler<?> projectsLoadedHandler, @Nullable IntermediateResultHandler<?> buildFinishedHandler) {
        this.projectsLoadedHandler = projectsLoadedHandler;
        this.buildFinishedHandler = buildFinishedHandler;
    }

    @Override
    public void onResult(PhasedActionResult<?> result2) {
        Object model = result2.getResult();
        PhasedActionResult.Phase type = result2.getPhase();
        if (type == PhasedActionResult.Phase.PROJECTS_LOADED) {
            this.onComplete(model, this.projectsLoadedHandler);
        } else if (type == PhasedActionResult.Phase.BUILD_FINISHED) {
            this.onComplete(model, this.buildFinishedHandler);
        }
    }

    private <T> void onComplete(Object result2, @Nullable IntermediateResultHandler<T> handler) {
        if (handler != null) {
            handler.onComplete(Cast.uncheckedNonnullCast(result2));
        }
    }
}

