/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.IsolatableSerializerRegistry;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.TransportableActionExecutionSpec;
import org.gradle.workers.internal.WorkSerializationException;
import org.gradle.workers.internal.WorkerRequirement;

public class DefaultActionExecutionSpecFactory
implements ActionExecutionSpecFactory {
    private final IsolatableFactory isolatableFactory;
    private final IsolatableSerializerRegistry serializerRegistry;

    public DefaultActionExecutionSpecFactory(IsolatableFactory isolatableFactory, IsolatableSerializerRegistry serializerRegistry) {
        this.isolatableFactory = isolatableFactory;
        this.serializerRegistry = serializerRegistry;
    }

    @Override
    public <T extends WorkParameters> TransportableActionExecutionSpec newTransportableSpec(IsolatedParametersActionExecutionSpec<T> spec) {
        return new TransportableActionExecutionSpec(spec.getImplementationClass().getName(), this.serialize(spec.getIsolatedParams()), spec.getClassLoaderStructure(), spec.getBaseDir(), spec.isInternalServicesRequired());
    }

    @Override
    public <T extends WorkParameters> IsolatedParametersActionExecutionSpec<T> newIsolatedSpec(String displayName, Class<? extends WorkAction<T>> implementationClass, T params, WorkerRequirement workerRequirement, boolean usesInternalServices) {
        ClassLoaderStructure classLoaderStructure = workerRequirement instanceof IsolatedClassLoaderWorkerRequirement ? ((IsolatedClassLoaderWorkerRequirement)workerRequirement).getClassLoaderStructure() : null;
        return new IsolatedParametersActionExecutionSpec<T>(implementationClass, displayName, implementationClass.getName(), this.isolatableFactory.isolate(params), classLoaderStructure, workerRequirement.getWorkerDirectory(), usesInternalServices);
    }

    @Override
    public <T extends WorkParameters> SimpleActionExecutionSpec<T> newSimpleSpec(IsolatedParametersActionExecutionSpec<T> spec) {
        WorkParameters params = (WorkParameters)Cast.uncheckedCast(spec.getIsolatedParams().isolate());
        return new SimpleActionExecutionSpec<WorkParameters>(spec.getImplementationClass(), params, spec.isInternalServicesRequired());
    }

    @Override
    public <T extends WorkParameters> SimpleActionExecutionSpec<T> newSimpleSpec(TransportableActionExecutionSpec spec) {
        WorkParameters params = (WorkParameters)Cast.uncheckedCast(this.deserialize(spec.getSerializedParameters()).isolate());
        return new SimpleActionExecutionSpec<WorkParameters>((Class)Cast.uncheckedCast(this.fromClassName(spec.getImplementationClassName())), params, spec.isInternalServicesRequired());
    }

    Class<?> fromClassName(String className) {
        try {
            return ClassLoaderUtils.classFromContextLoader(className);
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not deserialize unit of work.", e);
        }
    }

    private byte[] serialize(Isolatable<?> isolatable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        KryoBackedEncoder encoder = new KryoBackedEncoder(outputStream);
        try {
            this.serializerRegistry.writeIsolatable(encoder, isolatable);
            encoder.flush();
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not serialize unit of work.", e);
        }
        return outputStream.toByteArray();
    }

    private Isolatable<?> deserialize(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        KryoBackedDecoder decoder = new KryoBackedDecoder(inputStream);
        try {
            return this.serializerRegistry.readIsolatable(decoder);
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not deserialize unit of work.", e);
        }
    }
}

