/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.session.BuildSessionLifecycleListener;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonExpiration;
import org.gradle.workers.internal.WorkerDaemonStarter;

public class WorkerDaemonClientsManager
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonClientsManager.class);
    private final Object lock = new Object();
    private final List<WorkerDaemonClient> allClients = new ArrayList<WorkerDaemonClient>();
    private final List<WorkerDaemonClient> idleClients = new ArrayList<WorkerDaemonClient>();
    private final Action<WorkerProcess> workerProcessCleanupAction = new WorkerProcessCleanupAction();
    private final WorkerDaemonStarter workerDaemonStarter;
    private final ListenerManager listenerManager;
    private final LoggingManagerInternal loggingManager;
    private final OsMemoryInfo memoryInfo;
    private final BuildSessionLifecycleListener stopSessionScopeWorkers;
    private final OutputEventListener logLevelChangeEventListener;
    private final WorkerDaemonExpiration workerDaemonExpiration;
    private final MemoryManager memoryManager;
    private volatile LogLevel currentLogLevel;

    public WorkerDaemonClientsManager(WorkerDaemonStarter workerDaemonStarter, ListenerManager listenerManager, LoggingManagerInternal loggingManager, MemoryManager memoryManager, OsMemoryInfo memoryInfo) {
        this.workerDaemonStarter = workerDaemonStarter;
        this.listenerManager = listenerManager;
        this.loggingManager = loggingManager;
        this.memoryInfo = memoryInfo;
        this.stopSessionScopeWorkers = new StopSessionScopedWorkers();
        listenerManager.addListener(this.stopSessionScopeWorkers);
        this.logLevelChangeEventListener = new LogLevelChangeEventListener();
        loggingManager.addOutputEventListener(this.logLevelChangeEventListener);
        this.currentLogLevel = loggingManager.getLevel();
        this.memoryManager = memoryManager;
        this.workerDaemonExpiration = new WorkerDaemonExpiration(this, this.getTotalPhysicalMemory());
        memoryManager.addMemoryHolder(this.workerDaemonExpiration);
    }

    public WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions) {
        return this.reserveIdleClient(forkOptions, this.idleClients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions, List<WorkerDaemonClient> clients) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<WorkerDaemonClient> it = clients.iterator();
            while (it.hasNext()) {
                WorkerDaemonClient candidate = it.next();
                if (!candidate.isCompatibleWith(forkOptions)) continue;
                it.remove();
                if (candidate.getLogLevel() != this.currentLogLevel) {
                    LOGGER.info("Log level has changed, stopping idle worker daemon with out-of-date log level.");
                    candidate.stop();
                    continue;
                }
                return candidate;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerDaemonClient reserveNewClient(DaemonForkOptions forkOptions) {
        WorkerDaemonClient client = this.workerDaemonStarter.startDaemon(forkOptions, this.workerProcessCleanupAction);
        Object object = this.lock;
        synchronized (object) {
            this.allClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(WorkerDaemonClient client) {
        Object object = this.lock;
        synchronized (object) {
            if (!client.isFailed()) {
                this.idleClients.add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.stopWorkers(this.allClients);
            this.allClients.clear();
            this.idleClients.clear();
            this.listenerManager.removeListener(this.stopSessionScopeWorkers);
            this.memoryManager.removeMemoryHolder(this.workerDaemonExpiration);
        }
        this.loggingManager.removeOutputEventListener(this.logLevelChangeEventListener);
    }

    private long getTotalPhysicalMemory() {
        try {
            return this.memoryInfo.getOsSnapshot().getPhysicalMemory().getTotal();
        }
        catch (UnsupportedOperationException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectIdleClientsToStop(Transformer<List<WorkerDaemonClient>, List<WorkerDaemonClient>> selectionFunction) {
        Object object = this.lock;
        synchronized (object) {
            List<WorkerDaemonClient> sortedClients = CollectionUtils.sort(this.idleClients, Comparator.comparingInt(WorkerDaemonClient::getUses));
            List<WorkerDaemonClient> clientsToStop = selectionFunction.transform(new ArrayList<WorkerDaemonClient>(sortedClients));
            if (!clientsToStop.isEmpty()) {
                this.stopWorkers(clientsToStop);
            }
        }
    }

    private void stopWorkers(List<WorkerDaemonClient> clientsToStop) {
        if (clientsToStop.size() > 0) {
            int clientCount = clientsToStop.size();
            LOGGER.debug("Stopping {} worker daemon(s).", clientCount);
            ArrayList failures = Lists.newArrayList();
            for (WorkerDaemonClient client : clientsToStop) {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    failures.add(e);
                }
            }
            this.idleClients.removeAll(clientsToStop);
            this.allClients.removeAll(clientsToStop);
            if (!failures.isEmpty()) {
                if (failures.size() == 1) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)failures.get(0));
                }
                throw new DefaultMultiCauseException("Not all worker daemon(s) could be stopped.", (Iterable<? extends Throwable>)failures);
            }
            LOGGER.info("Stopped {} worker daemon(s).", clientCount);
        }
    }

    private class WorkerProcessCleanupAction
    implements Action<WorkerProcess> {
        private WorkerProcessCleanupAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(WorkerProcess workerProcess) {
            Object object = WorkerDaemonClientsManager.this.lock;
            synchronized (object) {
                Iterator iterator = WorkerDaemonClientsManager.this.allClients.iterator();
                while (iterator.hasNext()) {
                    WorkerDaemonClient client = (WorkerDaemonClient)iterator.next();
                    if (!client.isProcess(workerProcess)) continue;
                    client.setFailed(true);
                    iterator.remove();
                }
            }
        }
    }

    private class LogLevelChangeEventListener
    implements OutputEventListener {
        private LogLevelChangeEventListener() {
        }

        @Override
        public void onOutput(OutputEvent event) {
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent logLevelChangeEvent = (LogLevelChangeEvent)event;
                WorkerDaemonClientsManager.this.currentLogLevel = logLevelChangeEvent.getNewLogLevel();
            }
        }
    }

    private class StopSessionScopedWorkers
    implements BuildSessionLifecycleListener {
        private StopSessionScopedWorkers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeComplete() {
            Object object = WorkerDaemonClientsManager.this.lock;
            synchronized (object) {
                List<WorkerDaemonClient> sessionScopedClients = CollectionUtils.filter(WorkerDaemonClientsManager.this.allClients, client -> client.getKeepAliveMode() == KeepAliveMode.SESSION);
                WorkerDaemonClientsManager.this.stopWorkers(sessionScopedClients);
            }
        }
    }
}

