/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.util.internal.CollectionUtils;

public class GarbageCollectorMonitoringStrategy {
    public static final GarbageCollectorMonitoringStrategy ORACLE_PARALLEL_CMS = new GarbageCollectorMonitoringStrategy("PS Old Gen", "Metaspace", "PS MarkSweep", 1.2, 80, 80, 5.0);
    public static final GarbageCollectorMonitoringStrategy ORACLE_6_CMS = new GarbageCollectorMonitoringStrategy("CMS Old Gen", "Metaspace", "ConcurrentMarkSweep", 1.2, 80, 80, 5.0);
    public static final GarbageCollectorMonitoringStrategy ORACLE_SERIAL = new GarbageCollectorMonitoringStrategy("Tenured Gen", "Metaspace", "MarkSweepCompact", 1.2, 80, 80, 5.0);
    public static final GarbageCollectorMonitoringStrategy ORACLE_G1 = new GarbageCollectorMonitoringStrategy("G1 Old Gen", "Metaspace", "G1 Old Generation", 0.4, 75, 80, 2.0);
    public static final GarbageCollectorMonitoringStrategy IBM_ALL = new GarbageCollectorMonitoringStrategy("Java heap", "Not Used", "MarkSweepCompact", 0.8, 70, -1, 6.0);
    public static final GarbageCollectorMonitoringStrategy UNKNOWN = new GarbageCollectorMonitoringStrategy(null, null, null, -1.0, -1, -1, -1.0);
    public static final List<GarbageCollectorMonitoringStrategy> STRATEGIES = ImmutableList.of((Object)ORACLE_PARALLEL_CMS, (Object)ORACLE_6_CMS, (Object)ORACLE_SERIAL, (Object)ORACLE_G1, (Object)IBM_ALL, (Object)UNKNOWN);
    private static final Logger LOGGER = Logging.getLogger(GarbageCollectionMonitor.class);
    private final String heapPoolName;
    private final String nonHeapPoolName;
    private final String garbageCollectorName;
    private final double gcRateThreshold;
    private final int heapUsageThreshold;
    private final int nonHeapUsageThreshold;
    private final double thrashingThreshold;

    @VisibleForTesting
    public GarbageCollectorMonitoringStrategy(String heapPoolName, String nonHeapPoolName, String garbageCollectorName, double gcRateThreshold, int heapUsageThreshold, int nonHeapUsageThreshold, double thrashingThreshold) {
        this.heapPoolName = heapPoolName;
        this.nonHeapPoolName = nonHeapPoolName;
        this.garbageCollectorName = garbageCollectorName;
        this.gcRateThreshold = gcRateThreshold;
        this.heapUsageThreshold = heapUsageThreshold;
        this.nonHeapUsageThreshold = nonHeapUsageThreshold;
        this.thrashingThreshold = thrashingThreshold;
    }

    public String getHeapPoolName() {
        return this.heapPoolName;
    }

    public String getNonHeapPoolName() {
        return this.nonHeapPoolName;
    }

    public String getGarbageCollectorName() {
        return this.garbageCollectorName;
    }

    public double getGcRateThreshold() {
        return this.gcRateThreshold;
    }

    public int getHeapUsageThreshold() {
        return this.heapUsageThreshold;
    }

    public int getNonHeapUsageThreshold() {
        return this.nonHeapUsageThreshold;
    }

    public double getThrashingThreshold() {
        return this.thrashingThreshold;
    }

    public boolean isAboveHeapUsageThreshold(int percent) {
        return this.heapUsageThreshold != -1 && percent >= this.heapUsageThreshold;
    }

    public boolean isAboveNonHeapUsageThreshold(int percent) {
        return this.nonHeapUsageThreshold != -1 && percent >= this.nonHeapUsageThreshold;
    }

    public boolean isAboveGcRateThreshold(double gcEventsPerSec) {
        return this.gcRateThreshold != -1.0 && gcEventsPerSec >= this.gcRateThreshold;
    }

    public boolean isAboveGcThrashingThreshold(double gcEventsPerSec) {
        return this.thrashingThreshold != -1.0 && gcEventsPerSec >= this.thrashingThreshold;
    }

    public static GarbageCollectorMonitoringStrategy determineGcStrategy() {
        List garbageCollectors = CollectionUtils.collect(ManagementFactory.getGarbageCollectorMXBeans(), MemoryManagerMXBean::getName);
        GarbageCollectorMonitoringStrategy gcStrategy = (GarbageCollectorMonitoringStrategy)CollectionUtils.findFirst(STRATEGIES, strategy -> garbageCollectors.contains(strategy.getGarbageCollectorName()));
        if (gcStrategy == null) {
            LOGGER.info("Unable to determine a garbage collection monitoring strategy for {}", (Object)Jvm.current());
            return UNKNOWN;
        }
        List memoryPools = CollectionUtils.collect(ManagementFactory.getMemoryPoolMXBeans(), MemoryPoolMXBean::getName);
        if (!memoryPools.contains(gcStrategy.heapPoolName) || !memoryPools.contains(gcStrategy.nonHeapPoolName)) {
            LOGGER.info("Unable to determine which memory pools to monitor for {}", (Object)Jvm.current());
            return UNKNOWN;
        }
        return gcStrategy;
    }
}

