/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.AbstractFSManifestIterable;

public class FSManifestIterable
extends AbstractFSManifestIterable<File> {
    public static final Set<String> NON_BUNDLE_DIRS = new HashSet<String>(Arrays.asList("source", "sources", "javadoc", "javadocs", "doc", "docs"));
    public static final FilenameFilter DEFAULT_DIR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir2, String name) {
            return !name.equals(".svn") && !NON_BUNDLE_DIRS.contains(name);
        }
    };
    public static final FilenameFilter DEFAULT_BUNDLE_FILTER;
    @Deprecated
    public static final FilenameFilter DEFAULT_BUNLDE_FILTER;
    private FilenameFilter dirFilter = DEFAULT_DIR_FILTER;
    private FilenameFilter bundleFilter = DEFAULT_BUNDLE_FILTER;

    public FSManifestIterable(File root) {
        super(root);
    }

    public FilenameFilter getDirFilter() {
        return this.dirFilter;
    }

    public void setDirFilter(FilenameFilter dirFilter) {
        this.dirFilter = dirFilter;
    }

    public FilenameFilter getBundleFilter() {
        return this.bundleFilter;
    }

    public void setBundleFilter(FilenameFilter bundleFilter) {
        this.bundleFilter = bundleFilter;
    }

    @Override
    protected URI buildBundleURI(File location) {
        try {
            return new URI(location.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected file to url conversion error", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected url to uri conversion error", e);
        }
    }

    @Override
    protected InputStream getInputStream(File f) throws FileNotFoundException {
        return new FileInputStream(f);
    }

    @Override
    protected List<File> listBundleFiles(File dir2) throws IOException {
        return Arrays.asList(dir2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && FSManifestIterable.this.bundleFilter.accept(f.getParentFile(), f.getName());
            }
        }));
    }

    @Override
    protected List<File> listDirs(File dir2) throws IOException {
        return Arrays.asList(dir2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && (FSManifestIterable.this.dirFilter == null || FSManifestIterable.this.dirFilter.accept(f.getParentFile(), f.getName()));
            }
        }));
    }

    static {
        DEFAULT_BUNLDE_FILTER = DEFAULT_BUNDLE_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.endsWith(".jar");
            }
        };
    }
}

