/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class DirectorySelector
implements DiscoverySelector {
    private final String path;

    DirectorySelector(String path) {
        this.path = path;
    }

    public File getDirectory() {
        return new File(this.path);
    }

    public Path getPath() {
        return Paths.get(this.path, new String[0]);
    }

    public String getRawPath() {
        return this.path;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectorySelector that = (DirectorySelector)o;
        return Objects.equals(this.path, that.path);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("path", this.path).toString();
    }
}

