/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.type.DispJVMKt;
import org.kodein.type.JVMAbstractTypeToken;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.JVMUtilsKt;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0012\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/kodein/type/JVMGenericArrayTypeToken;", "T", "Lorg/kodein/type/JVMAbstractTypeToken;", "jvmType", "Ljava/lang/reflect/GenericArrayType;", "(Ljava/lang/reflect/GenericArrayType;)V", "getJvmType", "()Ljava/lang/reflect/GenericArrayType;", "getGenericParameters", "", "Lorg/kodein/type/TypeToken;", "()[Lorg/kodein/type/TypeToken;", "getRaw", "getSuper", "", "isGeneric", "", "isWildcard", "qualifiedErasedDispString", "", "simpleErasedDispString", "kaverit"})
public final class JVMGenericArrayTypeToken<T>
extends JVMAbstractTypeToken<T> {
    @NotNull
    private final GenericArrayType jvmType;

    public JVMGenericArrayTypeToken(@NotNull GenericArrayType jvmType) {
        Intrinsics.checkNotNullParameter((Object)jvmType, (String)"jvmType");
        this.jvmType = jvmType;
    }

    @Override
    @NotNull
    public GenericArrayType getJvmType() {
        return this.jvmType;
    }

    @Override
    @NotNull
    public String simpleErasedDispString() {
        return DispJVMKt.simpleErasedName(this.getJvmType());
    }

    @Override
    @NotNull
    public String qualifiedErasedDispString() {
        return DispJVMKt.qualifiedErasedName(this.getJvmType());
    }

    @Override
    @NotNull
    public TypeToken<T> getRaw() {
        Type type = this.getJvmType().getGenericComponentType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"jvmType.genericComponentType");
        Type type2 = JVMUtilsKt.getJvmType(TypeTokensJVMKt.typeToken(type).getRaw());
        Class clazz = type2 instanceof Class ? (Class)type2 : null;
        if (clazz == null) {
            throw new IllegalStateException("Could not get raw array component type.".toString());
        }
        Class rawComponent = clazz;
        JVMTypeToken<?> jVMTypeToken = TypeTokensJVMKt.typeToken(JVMUtilsKt.jvmArrayType(rawComponent));
        Intrinsics.checkNotNull(jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.TypeToken<T of org.kodein.type.JVMGenericArrayTypeToken>");
        return jVMTypeToken;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    @NotNull
    public TypeToken<?>[] getGenericParameters() {
        TypeToken[] typeTokenArray = new TypeToken[1];
        Type type = this.getJvmType().getGenericComponentType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"jvmType.genericComponentType");
        typeTokenArray[0] = TypeTokensJVMKt.typeToken(type);
        return typeTokenArray;
    }

    @Override
    public boolean isWildcard() {
        return Intrinsics.areEqual((Object)this.getJvmType().getGenericComponentType(), Object.class) || this.getJvmType().getGenericComponentType() instanceof WildcardType;
    }

    @Override
    @NotNull
    public List<TypeToken<?>> getSuper() {
        return CollectionsKt.emptyList();
    }
}

