/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.consistent;

import com.dynatrace.hash4j.consistent.ConsistentBucketHasher;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.util.Preconditions;
import java.util.Objects;

class ConsistentJumpBucketHasher
implements ConsistentBucketHasher {
    private final PseudoRandomGenerator pseudoRandomGenerator;

    ConsistentJumpBucketHasher(PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        Objects.requireNonNull(pseudoRandomGeneratorProvider);
        this.pseudoRandomGenerator = pseudoRandomGeneratorProvider.create();
    }

    @Override
    public int getBucket(long hash, int numBuckets) {
        int next;
        Preconditions.checkArgument(numBuckets > 0, "buckets must be positive");
        this.pseudoRandomGenerator.reset(hash);
        int candidate = 0;
        while ((next = (int)((double)(candidate + 1) / this.pseudoRandomGenerator.nextDouble())) > candidate && next < numBuckets) {
            candidate = next;
        }
        return candidate;
    }
}

