/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.Hasher;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

abstract class AbstractHasher
implements Hasher {
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle CHAR_HANDLE = MethodHandles.byteArrayViewVarHandle(char[].class, ByteOrder.LITTLE_ENDIAN);

    protected AbstractHasher() {
    }

    protected static final long unsignedMultiplyHigh(long x, long y) {
        return Math.multiplyHigh(x, y) + (x >> 63 & y) + (y >> 63 & x);
    }

    protected static char getChar(byte[] b, int off) {
        return CHAR_HANDLE.get(b, off);
    }

    protected static short getShort(byte[] b, int off) {
        return SHORT_HANDLE.get(b, off);
    }

    protected static int getInt(byte[] b, int off) {
        return INT_HANDLE.get(b, off);
    }

    protected static long getLong(byte[] b, int off) {
        return LONG_HANDLE.get(b, off);
    }

    protected static void setLong(byte[] b, int off, long v) {
        LONG_HANDLE.set(b, off, v);
    }

    protected static void setInt(byte[] b, int off, int v) {
        INT_HANDLE.set(b, off, v);
    }

    protected static void setShort(byte[] b, int off, short v) {
        SHORT_HANDLE.set(b, off, v);
    }

    protected static long getLong(CharSequence s, int off) {
        return (long)s.charAt(off) | (long)s.charAt(off + 1) << 16 | (long)s.charAt(off + 2) << 32 | (long)s.charAt(off + 3) << 48;
    }

    protected static int getInt(CharSequence s, int off) {
        return s.charAt(off) | s.charAt(off + 1) << 16;
    }

    protected static void setChar(byte[] b, int off, char v) {
        CHAR_HANDLE.set(b, off, v);
    }
}

