/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.AbstractKomihash;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;

class Komihash5_0
extends AbstractKomihash {
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = Komihash5_0.create(0L);

    static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher64 create(long useSeed) {
        return new Komihash5_0(useSeed);
    }

    private Komihash5_0(long seed) {
        super(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        long tmp4;
        long tmp3;
        long tmp2;
        long tmp1;
        boolean nonZeroLength;
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        boolean bl = nonZeroLength = len > 0;
        if (len > 63) {
            do {
                tmp1 = see1 ^ Komihash5_0.getLong(input, off);
                tmp2 = see5 ^ Komihash5_0.getLong(input, off + 32);
                tmp3 = see2 ^ Komihash5_0.getLong(input, off + 8);
                tmp4 = see6 ^ Komihash5_0.getLong(input, off + 40);
                long tmp5 = see3 ^ Komihash5_0.getLong(input, off + 16);
                long tmp6 = see7 ^ Komihash5_0.getLong(input, off + 48);
                long tmp7 = see4 ^ Komihash5_0.getLong(input, off + 24);
                long tmp8 = see8 ^ Komihash5_0.getLong(input, off + 56);
                see1 = tmp1 * tmp2;
                see2 = tmp3 * tmp4;
                see3 = tmp5 * tmp6;
                see4 = tmp7 * tmp8;
                see2 ^= (see5 += Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2));
                see3 ^= (see6 += Komihash5_0.unsignedMultiplyHigh(tmp3, tmp4));
                see4 ^= (see7 += Komihash5_0.unsignedMultiplyHigh(tmp5, tmp6));
                see1 ^= (see8 += Komihash5_0.unsignedMultiplyHigh(tmp7, tmp8));
                off += 64;
            } while ((len -= 64) > 63);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 31) {
            tmp1 = see1 ^ Komihash5_0.getLong(input, off);
            tmp2 = see5 ^ Komihash5_0.getLong(input, off + 8);
            see1 = tmp1 * tmp2;
            tmp3 = (see1 ^= (see5 += Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2))) ^ Komihash5_0.getLong(input, off + 16);
            tmp4 = see5 ^ Komihash5_0.getLong(input, off + 24);
            see1 = tmp3 * tmp4;
            see1 ^= (see5 += Komihash5_0.unsignedMultiplyHigh(tmp3, tmp4));
            off += 32;
            len -= 32;
        }
        if (len > 15) {
            tmp1 = see1 ^ Komihash5_0.getLong(input, off);
            tmp2 = see5 ^ Komihash5_0.getLong(input, off + 8);
            see1 = tmp1 * tmp2;
            see1 ^= (see5 += Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2));
            off += 16;
            len -= 16;
        }
        long r2h = see5;
        long r2l = see1;
        int ml8 = len << 3;
        if (len > 7) {
            r2l ^= Komihash5_0.getLong(input, off);
            long y = Komihash5_0.getLong(input, off + len - 8);
            r2h ^= 1L << ml8 | y >>> 1 >>> ~ml8;
        } else if (len > 3) {
            long mh = Komihash5_0.getInt(input, off + len - 4);
            long ml = (long)Komihash5_0.getInt(input, off) & 0xFFFFFFFFL;
            r2l ^= 1L << ml8 | ml | mh << 32 >>> -ml8;
        } else if (len > 0) {
            long m = 1L << ml8 | (long)input[off] & 0xFFL;
            if (len > 1) {
                m |= ((long)input[off + 1] & 0xFFL) << 8;
            }
            if (len > 2) {
                m |= ((long)input[off + 2] & 0xFFL) << 16;
            }
            r2l ^= m;
        } else if (nonZeroLength) {
            r2l ^= 1L;
        }
        return Komihash5_0.finish(r2h, r2l, see5);
    }

    @Override
    public long hashCharsToLong(CharSequence input) {
        long r1h;
        long r1l;
        long tmp2;
        long tmp1;
        boolean nonZeroLength;
        int off = 0;
        int len = input.length();
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        boolean bl = nonZeroLength = len > 0;
        if (len > 31) {
            do {
                tmp1 = see1 ^ Komihash5_0.getLong(input, off);
                tmp2 = see5 ^ Komihash5_0.getLong(input, off + 16);
                long tmp3 = see2 ^ Komihash5_0.getLong(input, off + 4);
                long tmp4 = see6 ^ Komihash5_0.getLong(input, off + 20);
                long tmp5 = see3 ^ Komihash5_0.getLong(input, off + 8);
                long tmp6 = see7 ^ Komihash5_0.getLong(input, off + 24);
                long tmp7 = see4 ^ Komihash5_0.getLong(input, off + 12);
                long tmp8 = see8 ^ Komihash5_0.getLong(input, off + 28);
                long r1l2 = tmp1 * tmp2;
                long r1h2 = Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2);
                long r2l = tmp3 * tmp4;
                long r2h = Komihash5_0.unsignedMultiplyHigh(tmp3, tmp4);
                long r3l = tmp5 * tmp6;
                long r3h = Komihash5_0.unsignedMultiplyHigh(tmp5, tmp6);
                long r4l = tmp7 * tmp8;
                long r4h = Komihash5_0.unsignedMultiplyHigh(tmp7, tmp8);
                off += 32;
                see2 = (see5 += r1h2) ^ r2l;
                see3 = (see6 += r2h) ^ r3l;
                see4 = (see7 += r3h) ^ r4l;
                see1 = (see8 += r4h) ^ r1l2;
            } while ((len -= 32) > 31);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 15) {
            tmp1 = see1 ^ Komihash5_0.getLong(input, off);
            tmp2 = see5 ^ Komihash5_0.getLong(input, off + 4);
            r1l = tmp1 * tmp2;
            r1h = Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2);
            see1 = (see5 += r1h) ^ r1l;
            long tmp3 = see1 ^ Komihash5_0.getLong(input, off + 8);
            long tmp4 = see5 ^ Komihash5_0.getLong(input, off + 12);
            r1l = tmp3 * tmp4;
            r1h = Komihash5_0.unsignedMultiplyHigh(tmp3, tmp4);
            see1 = (see5 += r1h) ^ r1l;
            off += 16;
            len -= 16;
        }
        if (len > 7) {
            tmp1 = see1 ^ Komihash5_0.getLong(input, off);
            tmp2 = see5 ^ Komihash5_0.getLong(input, off + 4);
            r1l = tmp1 * tmp2;
            r1h = Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2);
            see1 = (see5 += r1h) ^ r1l;
            off += 8;
            len -= 8;
        }
        long r2h = see5;
        long r2l = see1;
        int ml8 = len << 4;
        if (len > 3) {
            r2l ^= Komihash5_0.getLong(input, off);
            long y = Komihash5_0.getLong(input, off + len - 4);
            r2h ^= 1L << ml8 | y >>> 1 >>> ~ml8;
        } else if (len > 1) {
            long mh = Komihash5_0.getInt(input, off + len - 2);
            long ml = (long)Komihash5_0.getInt(input, off) & 0xFFFFFFFFL;
            r2l ^= 1L << ml8 | ml | mh << 32 >>> -ml8;
        } else if (len > 0) {
            long m = 1L << ml8 | (long)input.charAt(off);
            r2l ^= m;
        } else if (nonZeroLength) {
            r2l ^= 1L;
        }
        return Komihash5_0.finish(r2h, r2l, see5);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long tmp1 = this.seed1 ^ v1;
        long tmp2 = this.seed5 ^ v2;
        long see5 = Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2) + this.seed5;
        return Komihash5_0.finish(see5, tmp1 * tmp2 ^ (see5 ^ 1L), see5);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long tmp1 = this.seed1 ^ v1;
        long tmp2 = this.seed5 ^ v2;
        long see5 = Komihash5_0.unsignedMultiplyHigh(tmp1, tmp2) + this.seed5;
        return Komihash5_0.finish(see5 ^ 1L, tmp1 * tmp2 ^ (see5 ^ v3), see5);
    }

    private class HashStreamImpl
    extends AbstractKomihash.HashStreamImpl {
        private HashStreamImpl() {
        }

        @Override
        protected void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            b0 ^= this.see1;
            b1 ^= this.see2;
            b2 ^= this.see3;
            b3 ^= this.see4;
            b6 ^= this.see7;
            b7 ^= this.see8;
            long r1l = b0 * (b4 ^= this.see5);
            long r1h = AbstractHasher.unsignedMultiplyHigh(b0, b4);
            long r2l = b1 * (b5 ^= this.see6);
            long r2h = AbstractHasher.unsignedMultiplyHigh(b1, b5);
            long r3l = b2 * b6;
            long r3h = AbstractHasher.unsignedMultiplyHigh(b2, b6);
            long r4l = b3 * b7;
            long r4h = AbstractHasher.unsignedMultiplyHigh(b3, b7);
            this.see5 += r1h;
            this.see6 += r2h;
            this.see7 += r3h;
            this.see8 += r4h;
            this.see2 = this.see5 ^ r2l;
            this.see3 = this.see6 ^ r3l;
            this.see4 = this.see7 ^ r4l;
            this.see1 = this.see8 ^ r1l;
        }

        @Override
        protected long finalizeGetAsLong(long se1, long se5, int off, int len) {
            long r2h = se5;
            long r2l = se1;
            long y = 1L << (len << 3);
            if (len > 7) {
                r2l ^= AbstractHasher.getLong(this.buffer, off);
                r2h ^= y | AbstractHasher.getLong(this.buffer, off + 8) & y - 1L;
            } else if (this.byteCount > 0L) {
                r2l ^= y | AbstractHasher.getLong(this.buffer, off) & y - 1L;
            }
            return AbstractKomihash.finish(r2h, r2l, se5);
        }
    }
}

