/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui.hyperlinks;

import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.ui.TerminalAction;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LinkInfoEx
extends LinkInfo {
    private final PopupMenuGroupProvider myPopupMenuGroupProvider;
    private final HoverConsumer myHoverConsumer;

    public LinkInfoEx(@NotNull Runnable navigateCallback) {
        this(navigateCallback, null, null);
    }

    private LinkInfoEx(@NotNull Runnable navigateCallback, @Nullable PopupMenuGroupProvider popupMenuGroupProvider, @Nullable HoverConsumer hoverConsumer) {
        super(navigateCallback);
        this.myPopupMenuGroupProvider = popupMenuGroupProvider;
        this.myHoverConsumer = hoverConsumer;
    }

    @Nullable
    public PopupMenuGroupProvider getPopupMenuGroupProvider() {
        return this.myPopupMenuGroupProvider;
    }

    @Nullable
    public HoverConsumer getHoverConsumer() {
        return this.myHoverConsumer;
    }

    @Nullable
    public static PopupMenuGroupProvider getPopupMenuGroupProvider(@Nullable LinkInfo linkInfo) {
        return linkInfo instanceof LinkInfoEx ? ((LinkInfoEx)linkInfo).getPopupMenuGroupProvider() : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static HoverConsumer getHoverConsumer(@Nullable LinkInfo linkInfo) {
        return linkInfo instanceof LinkInfoEx ? ((LinkInfoEx)linkInfo).getHoverConsumer() : null;
    }

    public static final class Builder {
        private Runnable myNavigateCallback;
        private PopupMenuGroupProvider myPopupMenuGroupProvider;
        private HoverConsumer myHoverConsumer;

        @NotNull
        public Builder setNavigateCallback(@NotNull Runnable navigateCallback) {
            this.myNavigateCallback = navigateCallback;
            return this;
        }

        @NotNull
        public Builder setPopupMenuGroupProvider(@Nullable PopupMenuGroupProvider popupMenuGroupProvider) {
            this.myPopupMenuGroupProvider = popupMenuGroupProvider;
            return this;
        }

        @NotNull
        public Builder setHoverConsumer(@Nullable HoverConsumer hoverConsumer) {
            this.myHoverConsumer = hoverConsumer;
            return this;
        }

        @NotNull
        public LinkInfo build() {
            return new LinkInfoEx(this.myNavigateCallback, this.myPopupMenuGroupProvider, this.myHoverConsumer);
        }
    }

    public static interface HoverConsumer {
        public void onMouseEntered(@NotNull JComponent var1, @NotNull Rectangle var2);

        public void onMouseExited();
    }

    public static interface PopupMenuGroupProvider {
        @NotNull
        public List<TerminalAction> getPopupMenuGroup(@NotNull MouseEvent var1);
    }
}

