/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.gradle.profiler.CommandExec;

public class FlameGraphTool {
    private final File flamegraphScript;

    private static File createScript(String scriptName) {
        File file;
        block8: {
            InputStream stream = FlameGraphTool.class.getResource(scriptName + ".pl").openStream();
            try {
                File script = File.createTempFile(scriptName, ".pl");
                Files.copy(stream, script.toPath(), StandardCopyOption.REPLACE_EXISTING);
                script.deleteOnExit();
                script.setExecutable(true);
                file = script;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return file;
    }

    public FlameGraphTool() {
        this.flamegraphScript = FlameGraphTool.createScript("flamegraph");
    }

    public FlameGraphTool(File flamegraphHome) {
        this.flamegraphScript = new File(flamegraphHome, "flamegraph.pl");
    }

    public boolean checkInstallation() {
        try {
            new CommandExec().runAndCollectOutput("perl", "-v");
            return true;
        }
        catch (Exception e) {
            System.out.println("To get flamegraphs, please install perl.");
            return false;
        }
    }

    public void generateFlameGraph(File stacks, File flames, List<String> args) {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add("perl");
        allArgs.add(this.flamegraphScript.getAbsolutePath());
        allArgs.add(stacks.getAbsolutePath());
        allArgs.addAll(args);
        new CommandExec().runAndCollectOutput(flames, allArgs);
    }
}

