/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.instrument;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.gradle.profiler.instrument.GradleInstrumentation;

public class PidInstrumentation
extends GradleInstrumentation {
    private final File pidFile = File.createTempFile("gradle-profiler", "pid");

    public PidInstrumentation() throws IOException {
        this.pidFile.deleteOnExit();
    }

    @Override
    protected void generateInitScriptBody(PrintWriter writer) {
        writer.println("org.gradle.trace.pid.PidCollector.collect(gradle, new File(new URI('" + this.pidFile.toURI() + "')))");
    }

    public String getPidForLastBuild() {
        String string;
        BufferedReader reader = new BufferedReader(new FileReader(this.pidFile));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read daemon PID from file.", e);
            }
        }
        reader.close();
        return string;
    }
}

