/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.Nullable;

public class StudioSandboxCreator {
    public static StudioSandbox createSandbox(@Nullable Path sandboxDir) {
        return StudioSandboxCreator.createSandbox(sandboxDir, "plugins");
    }

    @VisibleForTesting
    public static StudioSandbox createSandbox(@Nullable Path sandboxDir, String pluginsDirName) {
        if (StudioSandboxCreator.shouldCreatePartialSandbox(sandboxDir)) {
            Path path = StudioSandboxCreator.newTempDir();
            Path pluginsDir = StudioSandboxCreator.createDir(new File(path.toFile(), pluginsDirName).toPath());
            Path logsDir = StudioSandboxCreator.createDir(new File(path.toFile(), "logs").toPath());
            Path scenarioOptionsDir = StudioSandboxCreator.createDir(new File(path.toFile(), "scenarioOptions").toPath());
            return StudioSandbox.partialSandbox(pluginsDir, logsDir, scenarioOptionsDir);
        }
        File sandboxDirFile = sandboxDir.toFile();
        Path configDir = StudioSandboxCreator.createDir(new File(sandboxDirFile, "config").toPath());
        Path systemDir = StudioSandboxCreator.createDir(new File(sandboxDirFile, "system").toPath());
        Path pluginsDir = StudioSandboxCreator.createDir(new File(sandboxDirFile, pluginsDirName).toPath());
        Path logDir = StudioSandboxCreator.createDir(new File(sandboxDirFile, "logs").toPath());
        Path scenarioOptionsDir = StudioSandboxCreator.createDir(new File(sandboxDirFile, "scenarioOptions").toPath());
        StudioSandboxCreator.disableIdeUpdate(configDir);
        return StudioSandbox.fullSandbox(configDir, systemDir, pluginsDir, logDir, scenarioOptionsDir);
    }

    private static boolean shouldCreatePartialSandbox(Path sandboxDir) {
        return sandboxDir == null;
    }

    private static void disableIdeUpdate(Path configDir) {
        String updatesContent = "<application>\n  <component name=\"UpdatesConfigurable\">\n    <option name=\"CHECK_NEEDED\" value=\"false\" />\n  </component>\n</application>\n";
        Path optionsDir = StudioSandboxCreator.createDir(new File(configDir.toFile(), "options").toPath());
        File updatesXml = new File(optionsDir.toFile(), "updates.xml");
        if (!updatesXml.exists()) {
            StudioSandboxCreator.writeUnchecked(updatesXml.toPath(), updatesContent, new OpenOption[0]);
        }
    }

    private static void writeUnchecked(Path path, String text, OpenOption ... options) {
        try {
            Files.write(path, text.getBytes(StandardCharsets.UTF_8), options);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not write content to a file: " + path, e);
        }
    }

    private static Path createDir(Path path) {
        new File(path.toAbsolutePath().toString()).mkdirs();
        return path.toAbsolutePath();
    }

    private static Path newTempDir() {
        try {
            return Files.createTempDirectory("android-studio-sandbox", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class StudioSandbox {
        private final Path configDir;
        private final Path systemDir;
        private final Path pluginsDir;
        private final Path logsDir;
        private final Path scenarioOptionsDir;

        private StudioSandbox(@Nullable Path configDir, @Nullable Path systemDir, Path pluginsDir, Path logsDir, Path scenarioOptionsDir) {
            this.configDir = configDir;
            this.systemDir = systemDir;
            this.pluginsDir = pluginsDir;
            this.logsDir = logsDir;
            this.scenarioOptionsDir = scenarioOptionsDir;
        }

        public Optional<Path> getConfigDir() {
            return Optional.ofNullable(this.configDir);
        }

        public Optional<Path> getSystemDir() {
            return Optional.ofNullable(this.systemDir);
        }

        public Path getLogsDir() {
            return this.logsDir;
        }

        public Path getScenarioOptionsDir() {
            return this.scenarioOptionsDir;
        }

        public Path getPluginsDir() {
            return this.pluginsDir;
        }

        public static StudioSandbox fullSandbox(Path configDir, Path systemDir, Path pluginsDir, Path logsDir, Path scenarioOptionsDir) {
            return new StudioSandbox(configDir, systemDir, pluginsDir, logsDir, scenarioOptionsDir);
        }

        public static StudioSandbox partialSandbox(Path pluginsDir, Path logsDir, Path scenarioOptionsDir) {
            return new StudioSandbox(null, null, pluginsDir, logsDir, scenarioOptionsDir);
        }
    }
}

