/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.yourkit;

import java.io.File;
import java.util.List;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.yourkit.YourKit;
import org.gradle.profiler.yourkit.YourKitConfig;

public class YourKitJvmArgsCalculator
implements JvmArgsCalculator {
    public static final int PORT = 10021;
    private final ScenarioSettings settings;
    private final YourKitConfig yourKitConfig;
    private final boolean startRecordingOnStart;
    private final boolean captureSnapshotOnProcessExit;

    public YourKitJvmArgsCalculator(ScenarioSettings settings, YourKitConfig yourKitConfig, boolean startRecordingOnStart, boolean captureSnapshotOnProcessExit) {
        this.settings = settings;
        this.yourKitConfig = yourKitConfig;
        this.startRecordingOnStart = startRecordingOnStart;
        this.captureSnapshotOnProcessExit = captureSnapshotOnProcessExit;
    }

    @Override
    public void calculateJvmArgs(List<String> jvmArgs) {
        File yourKitHome = YourKit.findYourKitHome();
        if (yourKitHome == null) {
            throw new IllegalArgumentException("Could not locate YourKit installation. Try setting the YOURKIT_HOME environment variable");
        }
        File jnilib = YourKit.findJniLib();
        if (!jnilib.isFile()) {
            throw new IllegalArgumentException("Could not locate YourKit library in YourKit home directory " + yourKitHome);
        }
        String agentOptions = "-agentpath:" + jnilib.getAbsolutePath() + "=dir=" + this.settings.getProfilerOutputBaseDir().getAbsolutePath() + ",sessionname=" + this.settings.getProfilerOutputBaseName() + ",port=10021";
        agentOptions = this.yourKitConfig.isMemorySnapshot() || this.yourKitConfig.isUseSampling() ? agentOptions + ",disabletracing,probe_disable=*" : agentOptions + ",disablealloc";
        if (this.startRecordingOnStart) {
            if (this.yourKitConfig.isMemorySnapshot()) {
                agentOptions = agentOptions + ",alloceach=10";
                if (this.captureSnapshotOnProcessExit) {
                    agentOptions = agentOptions + ",onexit=memory";
                }
            } else if (this.yourKitConfig.isUseSampling()) {
                agentOptions = agentOptions + ",sampling";
                if (this.captureSnapshotOnProcessExit) {
                    agentOptions = agentOptions + ",onexit=snapshot";
                }
            } else {
                agentOptions = agentOptions + ",tracing";
                if (this.captureSnapshotOnProcessExit) {
                    agentOptions = agentOptions + ",onexit=snapshot";
                }
            }
        }
        jvmArgs.add(agentOptions);
    }
}

