/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.jediterm.core.Color;
import com.jediterm.core.TerminalCoordinates;
import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.Questioner;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalMode;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.emulator.mouse.TerminalMouseListener;
import com.jediterm.terminal.model.JediTermDebouncerImpl;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.HyperlinkFilter;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import com.jediterm.terminal.ui.AwtTransformers;
import com.jediterm.terminal.ui.JediTermDefaultSearchComponent;
import com.jediterm.terminal.ui.JediTermExecutorServiceManager;
import com.jediterm.terminal.ui.JediTermSearchComponent;
import com.jediterm.terminal.ui.JediTermSearchComponentListener;
import com.jediterm.terminal.ui.PreConnectHandler;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.TerminalPanelListener;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.TerminalWidget;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JediTermWidget
extends JPanel
implements TerminalSession,
TerminalWidget,
TerminalActionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JediTermWidget.class);
    protected final TerminalPanel myTerminalPanel;
    private final JScrollBar myScrollBar;
    protected final JediTerminal myTerminal;
    private final AtomicReference<Session> myRunningSession = new AtomicReference();
    private final JediTermTypeAheadModel myTypeAheadTerminalModel;
    private final TerminalTypeAheadManager myTypeAheadManager;
    private JediTermSearchComponent myFindComponent;
    private final PreConnectHandler myPreConnectHandler;
    private TtyConnector myTtyConnector;
    private TerminalStarter myTerminalStarter;
    protected final SettingsProvider mySettingsProvider;
    private TerminalActionProvider myNextActionProvider;
    private final JLayeredPane myInnerPanel;
    private final TextProcessing myTextProcessing;
    private final List<TerminalWidgetListener> myListeners = new CopyOnWriteArrayList<TerminalWidgetListener>();
    private final Object myExecutorServiceManagerLock = new Object();
    private volatile TerminalExecutorServiceManager myExecutorServiceManager;

    public JediTermWidget(@NotNull SettingsProvider settingsProvider) {
        this(80, 24, settingsProvider);
    }

    public JediTermWidget(int columns, int lines, SettingsProvider settingsProvider) {
        super(new BorderLayout());
        this.mySettingsProvider = settingsProvider;
        StyleState styleState = this.createDefaultStyle();
        this.myTextProcessing = new TextProcessing(settingsProvider.getHyperlinkColor(), settingsProvider.getHyperlinkHighlightingMode());
        TerminalTextBuffer terminalTextBuffer = new TerminalTextBuffer(columns, lines, styleState, settingsProvider.getBufferMaxLinesCount(), this.myTextProcessing);
        this.myTextProcessing.setTerminalTextBuffer(terminalTextBuffer);
        this.myTerminalPanel = this.createTerminalPanel(this.mySettingsProvider, styleState, terminalTextBuffer);
        this.myTerminal = new JediTerminal((TerminalDisplay)this.myTerminalPanel, terminalTextBuffer, styleState);
        this.myTypeAheadTerminalModel = new JediTermTypeAheadModel((Terminal)this.myTerminal, terminalTextBuffer, settingsProvider);
        this.myTypeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)this.myTypeAheadTerminalModel);
        JediTermDebouncerImpl typeAheadDebouncer = new JediTermDebouncerImpl(() -> ((TerminalTypeAheadManager)this.myTypeAheadManager).debounce(), TerminalTypeAheadManager.MAX_TERMINAL_DELAY, this.getExecutorServiceManager());
        this.myTypeAheadManager.setClearPredictionsDebouncer((Debouncer)typeAheadDebouncer);
        this.myTerminalPanel.setTypeAheadManager(this.myTypeAheadManager);
        this.myTerminal.setModeEnabled(TerminalMode.AltSendsEscape, this.mySettingsProvider.altSendsEscape());
        this.myTerminalPanel.addTerminalMouseListener((TerminalMouseListener)this.myTerminal);
        this.myTerminalPanel.setNextProvider(this);
        this.myTerminalPanel.setCoordAccessor((TerminalCoordinates)this.myTerminal);
        this.myPreConnectHandler = this.createPreConnectHandler(this.myTerminal);
        this.myTerminalPanel.addCustomKeyListener(this.myPreConnectHandler);
        this.myScrollBar = this.createScrollBar();
        this.myInnerPanel = new JLayeredPane();
        this.myInnerPanel.setFocusable(false);
        this.setFocusable(false);
        this.myInnerPanel.setLayout(new TerminalLayout());
        this.myInnerPanel.add((Component)this.myTerminalPanel, "TERMINAL");
        this.myInnerPanel.add((Component)this.myScrollBar, "SCROLL");
        this.add((Component)this.myInnerPanel, "Center");
        this.myScrollBar.setModel(this.myTerminalPanel.getVerticalScrollModel());
        this.myTerminalPanel.init(this.myScrollBar);
        this.myTerminalPanel.setVisible(true);
    }

    protected JScrollBar createScrollBar() {
        JScrollBar scrollBar = new JScrollBar();
        scrollBar.setUI(new FindResultScrollBarUI());
        return scrollBar;
    }

    protected StyleState createDefaultStyle() {
        StyleState styleState = new StyleState();
        styleState.setDefaultStyle(this.mySettingsProvider.getDefaultStyle());
        return styleState;
    }

    protected TerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer terminalTextBuffer) {
        return new TerminalPanel(settingsProvider, terminalTextBuffer, styleState);
    }

    @Deprecated(forRemoval=true)
    private PreConnectHandler createPreConnectHandler(JediTerminal terminal) {
        return new PreConnectHandler((Terminal)terminal);
    }

    @Override
    public TerminalDisplay getTerminalDisplay() {
        return this.getTerminalPanel();
    }

    public TerminalPanel getTerminalPanel() {
        return this.myTerminalPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TerminalExecutorServiceManager getExecutorServiceManager() {
        TerminalExecutorServiceManager manager = this.myExecutorServiceManager;
        if (manager != null) {
            return manager;
        }
        Object object = this.myExecutorServiceManagerLock;
        synchronized (object) {
            manager = this.myExecutorServiceManager;
            if (manager == null) {
                this.myExecutorServiceManager = manager = this.createExecutorServiceManager();
            }
            return manager;
        }
    }

    @NotNull
    protected TerminalExecutorServiceManager createExecutorServiceManager() {
        return new JediTermExecutorServiceManager();
    }

    public TerminalTypeAheadManager getTypeAheadManager() {
        return this.myTypeAheadManager;
    }

    public void setTtyConnector(@NotNull TtyConnector ttyConnector) {
        TypeAheadTerminalModel.ShellType shellType;
        this.myTtyConnector = ttyConnector;
        if (ttyConnector instanceof ProcessTtyConnector) {
            List commandLine = ((ProcessTtyConnector)this.myTtyConnector).getCommandLine();
            shellType = TypeAheadTerminalModel.commandLineToShellType((List)commandLine);
        } else {
            shellType = TypeAheadTerminalModel.ShellType.Unknown;
        }
        this.myTypeAheadTerminalModel.setShellType(shellType);
        this.myTerminalStarter = this.createTerminalStarter(this.myTerminal, this.myTtyConnector);
        this.myTerminalPanel.setTerminalStarter(this.myTerminalStarter);
    }

    protected TerminalStarter createTerminalStarter(@NotNull JediTerminal terminal, @NotNull TtyConnector connector) {
        return new TerminalStarter(terminal, connector, (TerminalDataStream)new TtyBasedArrayDataStream(connector, () -> ((TerminalTypeAheadManager)this.myTypeAheadManager).onTerminalStateChanged()), this.myTypeAheadManager, this.getExecutorServiceManager());
    }

    @Override
    public TtyConnector getTtyConnector() {
        return this.myTtyConnector;
    }

    @Override
    public Terminal getTerminal() {
        return this.myTerminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AtomicReference<Session> atomicReference = this.myRunningSession;
        synchronized (atomicReference) {
            if (this.myRunningSession.get() == null) {
                EmulatorTask task = new EmulatorTask(() -> {
                    AtomicReference<Session> atomicReference = this.myRunningSession;
                    synchronized (atomicReference) {
                        this.myRunningSession.set(null);
                    }
                });
                Future<?> future = this.getExecutorServiceManager().getUnboundedExecutorService().submit(task);
                this.myRunningSession.set(new Session(task, future));
            } else {
                LOG.error("Should not try to start session again at this point... ");
            }
        }
    }

    @Deprecated
    public void stop() {
        this.stopRunningSession();
    }

    private void stopRunningSession() {
        Session session = this.myRunningSession.get();
        if (session != null) {
            session.stop();
        }
    }

    public boolean isSessionRunning() {
        return this.myRunningSession.get() != null;
    }

    @Override
    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.myTerminalPanel.getTerminalTextBuffer();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myTerminalPanel.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        this.myTerminalPanel.requestFocus();
    }

    @Override
    public boolean canOpenSession() {
        return !this.isSessionRunning();
    }

    @Override
    public void setTerminalPanelListener(TerminalPanelListener terminalPanelListener) {
        this.myTerminalPanel.setTerminalPanelListener(terminalPanelListener);
    }

    @Override
    public JediTermWidget createTerminalSession(TtyConnector ttyConnector) {
        this.setTtyConnector(ttyConnector);
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void close() {
        this.stopRunningSession();
        if (this.myTerminalStarter != null) {
            this.myTerminalStarter.close();
        }
        this.myTerminalPanel.dispose();
        this.getExecutorServiceManager().shutdownWhenAllExecuted();
    }

    @Override
    public List<TerminalAction> getActions() {
        return List.of(new TerminalAction(this.mySettingsProvider.getFindActionPresentation(), keyEvent -> {
            this.showFindText();
            return true;
        }).withMnemonicKey(70));
    }

    private void showFindText() {
        if (this.myFindComponent == null) {
            this.myFindComponent = this.createSearchComponent();
            final JComponent component = this.myFindComponent.getComponent();
            this.myInnerPanel.add((Component)component, "FIND");
            this.myInnerPanel.moveToFront(component);
            this.myInnerPanel.revalidate();
            this.myInnerPanel.repaint();
            component.requestFocus();
            final JediTermSearchComponentListener listener = new JediTermSearchComponentListener(){

                @Override
                public void searchSettingsChanged(@NotNull String textToFind, boolean ignoreCase) {
                    JediTermWidget.this.findText(textToFind, ignoreCase);
                }

                @Override
                public void hideSearchComponent() {
                    JediTermWidget.this.myInnerPanel.remove(component);
                    JediTermWidget.this.myInnerPanel.revalidate();
                    JediTermWidget.this.myInnerPanel.repaint();
                    JediTermWidget.this.myFindComponent = null;
                    JediTermWidget.this.myTerminalPanel.setFindResult(null);
                    JediTermWidget.this.myTerminalPanel.requestFocusInWindow();
                }

                @Override
                public void selectNextFindResult() {
                    JediTermWidget.this.myFindComponent.onResultUpdated(JediTermWidget.this.myTerminalPanel.selectNextFindResultItem());
                }

                @Override
                public void selectPrevFindResult() {
                    JediTermWidget.this.myFindComponent.onResultUpdated(JediTermWidget.this.myTerminalPanel.selectPrevFindResultItem());
                }
            };
            this.myFindComponent.addListener(listener);
            this.myFindComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        listener.hideSearchComponent();
                    } else if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 40) {
                        listener.selectNextFindResult();
                    } else if (keyEvent.getKeyCode() == 38) {
                        listener.selectPrevFindResult();
                    }
                }
            });
        } else {
            this.myFindComponent.getComponent().requestFocus();
        }
    }

    @NotNull
    protected JediTermSearchComponent createSearchComponent() {
        return new JediTermDefaultSearchComponent(this);
    }

    private void findText(String text, boolean ignoreCase) {
        SubstringFinder.FindResult results = this.myTerminal.searchInTerminalTextBuffer(text, ignoreCase);
        this.myTerminalPanel.setFindResult(results);
        this.myFindComponent.onResultUpdated(results);
        this.myScrollBar.repaint();
    }

    @Override
    public TerminalActionProvider getNextProvider() {
        return this.myNextActionProvider;
    }

    @Override
    public void setNextProvider(TerminalActionProvider actionProvider) {
        this.myNextActionProvider = actionProvider;
    }

    @Deprecated
    @Nullable
    public TerminalStarter getTerminalStarter() {
        return this.myTerminalStarter;
    }

    public void addHyperlinkFilter(HyperlinkFilter filter) {
        this.myTextProcessing.addHyperlinkFilter(filter);
    }

    @Override
    public void addListener(TerminalWidgetListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(TerminalWidgetListener listener) {
        this.myListeners.remove(listener);
    }

    private static class TerminalLayout
    implements LayoutManager {
        public static final String TERMINAL = "TERMINAL";
        public static final String SCROLL = "SCROLL";
        public static final String FIND = "FIND";
        private Component terminal;
        private Component scroll;
        private Component find;

        private TerminalLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (TERMINAL.equals(name)) {
                this.terminal = comp;
            } else if (FIND.equals(name)) {
                this.find = comp;
            } else if (SCROLL.equals(name)) {
                this.scroll = comp;
            } else {
                throw new IllegalArgumentException("unknown component name " + name);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.terminal) {
                this.terminal = null;
            }
            if (comp == this.scroll) {
                this.scroll = null;
            }
            if (comp == this.find) {
                this.find = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension d;
                Dimension dim = new Dimension(0, 0);
                if (this.terminal != null) {
                    d = this.terminal.getPreferredSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height = Math.max(d.height, dim.height);
                }
                if (this.scroll != null) {
                    d = this.scroll.getPreferredSize();
                    dim.width += d.width;
                    dim.height = Math.max(d.height, dim.height);
                }
                if (this.find != null) {
                    d = this.find.getPreferredSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height = Math.max(d.height, dim.height);
                }
                Insets insets = target.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension d;
                Dimension dim = new Dimension(0, 0);
                if (this.terminal != null) {
                    d = this.terminal.getMinimumSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height = Math.max(d.height, dim.height);
                }
                if (this.scroll != null) {
                    d = this.scroll.getPreferredSize();
                    dim.width += d.width;
                    dim.height = Math.max(d.height, dim.height);
                }
                if (this.find != null) {
                    d = this.find.getMinimumSize();
                    dim.width = Math.max(d.width, dim.width);
                    dim.height = Math.max(d.height, dim.height);
                }
                Insets insets = target.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets = target.getInsets();
                int top = insets.top;
                int bottom = target.getHeight() - insets.bottom;
                int left = insets.left;
                int right = target.getWidth() - insets.right;
                Dimension scrollDim = new Dimension(0, 0);
                if (this.scroll != null) {
                    scrollDim = this.scroll.getPreferredSize();
                    this.scroll.setBounds(right - scrollDim.width, top, scrollDim.width, bottom - top);
                }
                if (this.terminal != null) {
                    this.terminal.setBounds(left, top, right - left - scrollDim.width, bottom - top);
                }
                if (this.find != null) {
                    Dimension d = this.find.getPreferredSize();
                    this.find.setBounds(right - d.width - scrollDim.width, top, d.width, d.height);
                }
            }
        }
    }

    private class FindResultScrollBarUI
    extends BasicScrollBarUI {
        private FindResultScrollBarUI() {
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
            super.paintTrack(g, c, trackBounds);
            SubstringFinder.FindResult result = JediTermWidget.this.myTerminalPanel.getFindResult();
            if (result != null) {
                int modelHeight = this.scrollbar.getModel().getMaximum() - this.scrollbar.getModel().getMinimum();
                int anchorHeight = Math.max(2, trackBounds.height / modelHeight);
                Color color = JediTermWidget.this.mySettingsProvider.getTerminalColorPalette().getBackground(Objects.requireNonNull(JediTermWidget.this.mySettingsProvider.getFoundPatternColor().getBackground()));
                g.setColor(AwtTransformers.toAwtColor(color));
                for (SubstringFinder.FindResult.FindItem r : result.getItems()) {
                    int where = trackBounds.height * r.getStart().y / modelHeight;
                    g.fillRect(trackBounds.x, trackBounds.y + where, trackBounds.width, anchorHeight);
                }
            }
        }
    }

    private class EmulatorTask
    implements Runnable {
        private final TerminalStarter myStarter;
        private final Runnable myOnDone;

        public EmulatorTask(Runnable onDone) {
            this.myStarter = Objects.requireNonNull(JediTermWidget.this.myTerminalStarter);
            this.myOnDone = onDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TtyConnector ttyConnector = this.myStarter.getTtyConnector();
            try {
                if (ttyConnector.init((Questioner)JediTermWidget.this.myPreConnectHandler)) {
                    JediTermWidget.this.myTerminalPanel.addCustomKeyListener(JediTermWidget.this.myTerminalPanel.getTerminalKeyListener());
                    JediTermWidget.this.myTerminalPanel.removeCustomKeyListener(JediTermWidget.this.myPreConnectHandler);
                    this.myStarter.start();
                }
            }
            catch (Exception e) {
                LOG.error("Exception running terminal", (Throwable)e);
            }
            finally {
                try {
                    ttyConnector.close();
                }
                catch (Exception e) {}
                try {
                    for (TerminalWidgetListener listener : JediTermWidget.this.myListeners) {
                        listener.allSessionsClosed(JediTermWidget.this);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unhandled exception when closing terminal", (Throwable)e);
                }
                try {
                    this.myOnDone.run();
                }
                catch (Exception e) {
                    LOG.error("Unhandled exception when closing terminal", (Throwable)e);
                }
            }
        }

        void requestStop() {
            this.myStarter.requestEmulatorStop();
        }
    }

    private static class Session {
        private final EmulatorTask myEmulatorTask;
        private final Future<?> mySessionFuture;

        public Session(@NotNull EmulatorTask emulatorTask, @NotNull Future<?> sessionFuture) {
            this.myEmulatorTask = emulatorTask;
            this.mySessionFuture = sessionFuture;
        }

        void stop() {
            this.myEmulatorTask.requestStop();
            this.mySessionFuture.cancel(true);
        }
    }
}

