/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.random;

import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.util.Preconditions;
import java.util.Arrays;

public final class PermutationGenerator {
    private final int[] permutation;
    private final int[] currentVersion;
    private int idx;
    private int versionCounter;

    public PermutationGenerator(int size) {
        Preconditions.checkArgument(size > 0);
        this.idx = 0;
        this.versionCounter = 1;
        this.permutation = new int[size];
        this.currentVersion = new int[size];
    }

    public boolean hasNext() {
        return this.idx < this.permutation.length;
    }

    public int next(PseudoRandomGenerator pseudoRandomGenerator) {
        int k = this.idx + pseudoRandomGenerator.uniformInt(this.permutation.length - this.idx);
        int result = this.currentVersion[k] != this.versionCounter ? k : this.permutation[k];
        this.permutation[k] = this.currentVersion[this.idx] != this.versionCounter ? this.idx : this.permutation[this.idx];
        this.currentVersion[k] = this.versionCounter;
        ++this.idx;
        return result;
    }

    public void reset() {
        ++this.versionCounter;
        this.idx = 0;
        if (this.versionCounter == 0) {
            Arrays.fill(this.currentVersion, 0);
            this.versionCounter = 1;
        }
    }

    void setVersionCounterToMinus1() {
        this.versionCounter = -1;
    }
}

