/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.core;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    Windows,
    OS2,
    Mac,
    Linux,
    Other;


    @NotNull
    private static String getOsNameLowerCase() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public static Platform current() {
        String osName = Platform.getOsNameLowerCase();
        if (osName.startsWith("windows")) {
            return Windows;
        }
        if (osName.startsWith("os/2") || osName.startsWith("os2")) {
            return OS2;
        }
        if (osName.startsWith("mac")) {
            return Mac;
        }
        if (osName.startsWith("linux")) {
            return Linux;
        }
        return Other;
    }
}

