/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Describables;

public class DefaultPublishArtifactSet
extends DelegatingDomainObjectSet<PublishArtifact>
implements PublishArtifactSet {
    private final TaskDependencyInternal builtBy;
    private final FileCollection files;
    private final Describable displayName;

    public DefaultPublishArtifactSet(String displayName, DomainObjectSet<PublishArtifact> backingSet, FileCollectionFactory fileCollectionFactory, TaskDependencyFactory taskDependencyFactory) {
        this(Describables.of(displayName), backingSet, fileCollectionFactory, taskDependencyFactory);
    }

    public DefaultPublishArtifactSet(Describable displayName, DomainObjectSet<PublishArtifact> backingSet, FileCollectionFactory fileCollectionFactory, TaskDependencyFactory taskDependencyFactory) {
        super(backingSet);
        this.displayName = displayName;
        this.builtBy = taskDependencyFactory.visitingDependencies(context -> {
            for (PublishArtifact publishArtifact : this) {
                context.add(publishArtifact);
            }
        });
        this.files = fileCollectionFactory.create(this.builtBy, new ArtifactsFileCollection());
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    @Override
    public FileCollection getFiles() {
        return this.files;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.builtBy;
    }

    private class ArtifactsFileCollection
    implements MinimalFileSet {
        private ArtifactsFileCollection() {
        }

        @Override
        public String getDisplayName() {
            return DefaultPublishArtifactSet.this.displayName.getDisplayName();
        }

        @Override
        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (PublishArtifact artifact : DefaultPublishArtifactSet.this) {
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

