/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformInvocationFactory;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Cast;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformStep
implements TaskDependencyContainer,
Describable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformStep.class);
    private final Transform transform;
    private final TransformInvocationFactory transformInvocationFactory;
    private final ProjectInternal owningProject;
    private final InputFingerprinter globalInputFingerprinter;

    public TransformStep(Transform transform, TransformInvocationFactory transformInvocationFactory, DomainObjectContext owner, InputFingerprinter globalInputFingerprinter) {
        this.transform = transform;
        this.transformInvocationFactory = transformInvocationFactory;
        this.globalInputFingerprinter = globalInputFingerprinter;
        this.owningProject = owner.getProject();
    }

    public Transform getTransform() {
        return this.transform;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    public Deferrable<Try<TransformStepSubject>> createInvocation(TransformStepSubject subjectToTransform, TransformUpstreamDependencies upstreamDependencies, @Nullable NodeExecutionContext context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transforming {} with {}", (Object)subjectToTransform.getDisplayName(), (Object)this.transform.getDisplayName());
        }
        InputFingerprinter inputFingerprinter = context != null ? context.getService(InputFingerprinter.class) : this.globalInputFingerprinter;
        Try<TransformDependencies> resolvedDependencies = upstreamDependencies.computeArtifacts();
        return resolvedDependencies.map(dependencies -> {
            ImmutableList<File> inputArtifacts = subjectToTransform.getFiles();
            if (inputArtifacts.isEmpty()) {
                return Deferrable.completed(Try.successful(subjectToTransform.createSubjectFromResult((ImmutableList<File>)ImmutableList.of())));
            }
            if (inputArtifacts.size() > 1) {
                return Deferrable.deferred(() -> this.doTransform(subjectToTransform, inputFingerprinter, (TransformDependencies)dependencies, inputArtifacts));
            }
            File inputArtifact = (File)inputArtifacts.get(0);
            return this.transformInvocationFactory.createInvocation(this.transform, inputArtifact, (TransformDependencies)dependencies, subjectToTransform, inputFingerprinter).map(result2 -> result2.map(subjectToTransform::createSubjectFromResult));
        }).getOrMapFailure(failure -> Deferrable.completed(Try.failure(failure)));
    }

    private Try<TransformStepSubject> doTransform(TransformStepSubject subjectToTransform, InputFingerprinter inputFingerprinter, TransformDependencies dependencies, ImmutableList<File> inputArtifacts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File inputArtifact : inputArtifacts) {
            Try<ImmutableList<File>> result2 = this.transformInvocationFactory.createInvocation(this.transform, inputArtifact, dependencies, subjectToTransform, inputFingerprinter).completeAndGet();
            if (result2.getFailure().isPresent()) {
                return (Try)Cast.uncheckedCast(result2);
            }
            builder.addAll((Iterable)result2.get());
        }
        return Try.successful(subjectToTransform.createSubjectFromResult((ImmutableList<File>)builder.build()));
    }

    public void isolateParametersIfNotAlready() {
        this.transform.isolateParametersIfNotAlready();
    }

    public boolean requiresDependencies() {
        return this.transform.requiresDependencies();
    }

    @Override
    public String getDisplayName() {
        return this.transform.getDisplayName();
    }

    public ImmutableAttributes getFromAttributes() {
        return this.transform.getFromAttributes();
    }

    public String toString() {
        return this.transform.getDisplayName();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.transform.visitDependencies(context);
    }
}

