/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.ConfigurableUserClassFilePermissions;
import org.gradle.api.internal.file.AbstractFilePermissions;
import org.gradle.api.internal.file.ConfigurableUserClassFilePermissionsInternal;
import org.gradle.api.internal.file.DefaultConfigurableUserClassFilePermissions;
import org.gradle.api.model.ObjectFactory;

public class DefaultConfigurableFilePermissions
extends AbstractFilePermissions
implements ConfigurableFilePermissions {
    private final ConfigurableUserClassFilePermissionsInternal user;
    private final ConfigurableUserClassFilePermissionsInternal group;
    private final ConfigurableUserClassFilePermissionsInternal other;

    public static int getDefaultUnixNumeric(boolean isDirectory) {
        return isDirectory ? 493 : 420;
    }

    @Inject
    public DefaultConfigurableFilePermissions(ObjectFactory objectFactory, int unixNumeric) {
        this.user = objectFactory.newInstance(DefaultConfigurableUserClassFilePermissions.class, DefaultConfigurableFilePermissions.getUserPartOf(unixNumeric));
        this.group = objectFactory.newInstance(DefaultConfigurableUserClassFilePermissions.class, DefaultConfigurableFilePermissions.getGroupPartOf(unixNumeric));
        this.other = objectFactory.newInstance(DefaultConfigurableUserClassFilePermissions.class, DefaultConfigurableFilePermissions.getOtherPartOf(unixNumeric));
    }

    @Override
    public ConfigurableUserClassFilePermissions getUser() {
        return this.user;
    }

    @Override
    public void user(Action<? super ConfigurableUserClassFilePermissions> configureAction) {
        configureAction.execute(this.user);
    }

    @Override
    public ConfigurableUserClassFilePermissions getGroup() {
        return this.group;
    }

    @Override
    public void group(Action<? super ConfigurableUserClassFilePermissions> configureAction) {
        configureAction.execute(this.group);
    }

    @Override
    public ConfigurableUserClassFilePermissions getOther() {
        return this.other;
    }

    @Override
    public void other(Action<? super ConfigurableUserClassFilePermissions> configureAction) {
        configureAction.execute(this.other);
    }

    @Override
    public void unix(String unixNumericOrSymbolic) {
        try {
            String normalizedPermissions = DefaultConfigurableFilePermissions.normalizeUnixPermissions(unixNumericOrSymbolic);
            if (normalizedPermissions.length() == 3) {
                this.unix(DefaultConfigurableFilePermissions.toUnixNumericPermissions(normalizedPermissions));
            } else {
                this.user.unix(DefaultConfigurableFilePermissions.getUserPartOf(normalizedPermissions));
                this.group.unix(DefaultConfigurableFilePermissions.getGroupPartOf(normalizedPermissions));
                this.other.unix(DefaultConfigurableFilePermissions.getOtherPartOf(normalizedPermissions));
            }
        }
        catch (IllegalArgumentException cause) {
            throw new InvalidUserDataException("'" + unixNumericOrSymbolic + "' isn't a proper Unix permission. " + cause.getMessage());
        }
    }

    @Override
    public void unix(int unixNumeric) {
        this.user.unix(DefaultConfigurableFilePermissions.getUserPartOf(unixNumeric));
        this.group.unix(DefaultConfigurableFilePermissions.getGroupPartOf(unixNumeric));
        this.other.unix(DefaultConfigurableFilePermissions.getOtherPartOf(unixNumeric));
    }

    private static String normalizeUnixPermissions(String permissions) {
        String trimmed = permissions.trim();
        if (trimmed.length() == 4 && trimmed.startsWith("0")) {
            return trimmed.substring(1);
        }
        if (trimmed.length() != 3 && trimmed.length() != 9) {
            throw new IllegalArgumentException("Trimmed length must be either 3 (for numeric notation) or 9 (for symbolic notation).");
        }
        return trimmed;
    }

    private static int toUnixNumericPermissions(String permissions) {
        try {
            return Integer.parseInt(permissions, 8);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't be parsed as octal number.");
        }
    }
}

