/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AttributeBasedFileVisitDetailsFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

class PathVisitor
implements FileVisitor<Path> {
    private final Deque<FileVisitDetails> directoryDetailsHolder = new ArrayDeque<FileVisitDetails>();
    private final Spec<? super FileTreeElement> spec;
    private final boolean postfix;
    private final org.gradle.api.file.FileVisitor visitor;
    private final AtomicBoolean stopFlag;
    private final RelativePath rootPath;
    private final FileSystem fileSystem;

    public PathVisitor(Spec<? super FileTreeElement> spec, boolean postfix, org.gradle.api.file.FileVisitor visitor, AtomicBoolean stopFlag, RelativePath rootPath, FileSystem fileSystem) {
        this.spec = spec;
        this.postfix = postfix;
        this.visitor = visitor;
        this.stopFlag = stopFlag;
        this.rootPath = rootPath;
        this.fileSystem = fileSystem;
    }

    private boolean shouldVisit(FileTreeElement element) {
        return this.spec.isSatisfiedBy(element);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        FileVisitDetails details = this.getFileVisitDetails(dir, attrs);
        if (this.directoryDetailsHolder.size() == 0 || this.shouldVisit(details)) {
            this.directoryDetailsHolder.push(details);
            if (this.directoryDetailsHolder.size() > 1 && !this.postfix) {
                this.visitor.visitDir(details);
            }
            return this.checkStopFlag();
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    private FileVisitResult checkStopFlag() {
        return this.stopFlag.get() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        FileVisitDetails details = this.getFileVisitDetails(file, attrs);
        if (this.shouldVisit(details)) {
            if (attrs.isSymbolicLink()) {
                throw new GradleException(String.format("Couldn't follow symbolic link '%s'.", file));
            }
            this.visitor.visitFile(details);
        }
        return this.checkStopFlag();
    }

    private FileVisitDetails getFileVisitDetails(Path file, @Nullable BasicFileAttributes attrs) {
        FileVisitDetails dirDetails = this.directoryDetailsHolder.peek();
        if (dirDetails != null) {
            return AttributeBasedFileVisitDetailsFactory.getFileVisitDetails(file, dirDetails.getRelativePath(), attrs, this.stopFlag, this.fileSystem);
        }
        return AttributeBasedFileVisitDetailsFactory.getRootFileVisitDetails(file, this.rootPath, attrs, this.stopFlag, this.fileSystem);
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        FileVisitDetails details = this.getFileVisitDetails(file, null);
        if (PathVisitor.isNotFileSystemLoopException(exc) && this.shouldVisit(details)) {
            throw new GradleException(String.format("Could not read path '%s'.", file), exc);
        }
        return this.checkStopFlag();
    }

    private static boolean isNotFileSystemLoopException(@Nullable IOException e) {
        return e != null && !(e instanceof FileSystemLoopException);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) {
        if (exc != null) {
            if (!(exc instanceof FileSystemLoopException)) {
                throw new GradleException(String.format("Could not read directory path '%s'.", dir), exc);
            }
        } else if (this.postfix) {
            FileVisitDetails details = this.directoryDetailsHolder.peek();
            if (this.directoryDetailsHolder.size() > 1 && details != null) {
                this.visitor.visitDir(details);
            }
        }
        this.directoryDetailsHolder.pop();
        return this.checkStopFlag();
    }
}

