/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDiscoveringCompiler;
import org.gradle.api.internal.tasks.compile.ApiGroovyCompiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaHomeBasedJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.JdkJavaCompiler;
import org.gradle.api.internal.tasks.compile.MinimalGroovyCompileOptions;
import org.gradle.api.internal.tasks.compile.NormalizingGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.AbstractIsolatedCompilerWorkerExecutor;
import org.gradle.api.internal.tasks.compile.daemon.ClassloaderIsolatedCompilerWorkerExecutor;
import org.gradle.api.internal.tasks.compile.daemon.DaemonGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.ProcessIsolatedCompilerWorkerExecutor;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.tasks.WorkResult;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.IsolatedClassloaderWorkerFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

public class GroovyCompilerFactory
implements CompilerFactory<GroovyJavaJointCompileSpec> {
    private final WorkerDaemonFactory workerDaemonFactory;
    private final IsolatedClassloaderWorkerFactory inProcessWorkerFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final AnnotationProcessorDetector processorDetector;
    private final JvmVersionDetector jvmVersionDetector;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public GroovyCompilerFactory(WorkerDaemonFactory workerDaemonFactory, IsolatedClassloaderWorkerFactory inProcessWorkerFactory, JavaForkOptionsFactory forkOptionsFactory, AnnotationProcessorDetector processorDetector, JvmVersionDetector jvmVersionDetector, WorkerDirectoryProvider workerDirectoryProvider, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerDaemonFactory = workerDaemonFactory;
        this.inProcessWorkerFactory = inProcessWorkerFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.processorDetector = processorDetector;
        this.jvmVersionDetector = jvmVersionDetector;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    @Override
    public Compiler<GroovyJavaJointCompileSpec> newCompiler(GroovyJavaJointCompileSpec spec) {
        MinimalGroovyCompileOptions groovyOptions = spec.getGroovyCompileOptions();
        AbstractIsolatedCompilerWorkerExecutor compilerWorkerExecutor = groovyOptions.isFork() ? new ProcessIsolatedCompilerWorkerExecutor(this.workerDaemonFactory, this.actionExecutionSpecFactory) : new ClassloaderIsolatedCompilerWorkerExecutor(this.inProcessWorkerFactory, this.actionExecutionSpecFactory);
        DaemonGroovyCompiler groovyCompiler = new DaemonGroovyCompiler(this.workerDirectoryProvider.getWorkingDirectory(), DaemonSideCompiler.class, this.classPathRegistry, compilerWorkerExecutor, this.classLoaderRegistry, this.forkOptionsFactory, this.jvmVersionDetector);
        return new AnnotationProcessorDiscoveringCompiler<GroovyJavaJointCompileSpec>(new NormalizingGroovyCompiler(groovyCompiler), this.processorDetector);
    }

    public static class DaemonSideCompiler
    implements Compiler<GroovyJavaJointCompileSpec> {
        private final ProjectLayout projectLayout;
        private final List<File> javaCompilerPlugins;

        @Inject
        public DaemonSideCompiler(ProjectLayout projectLayout, List<File> javaCompilerPlugins) {
            this.projectLayout = projectLayout;
            this.javaCompilerPlugins = javaCompilerPlugins;
        }

        @Override
        public WorkResult execute(GroovyJavaJointCompileSpec spec) {
            JdkJavaCompiler javaCompiler = new JdkJavaCompiler(new JavaHomeBasedJavaCompilerFactory(this.javaCompilerPlugins));
            ApiGroovyCompiler groovyCompiler = new ApiGroovyCompiler(javaCompiler, this.projectLayout);
            return groovyCompiler.execute(spec);
        }
    }
}

