/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClassSetAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentCompilationAccess {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentCompilationAccess.class);
    private final ClassSetAnalyzer classSetAnalyzer;
    private final BuildOperationExecutor buildOperationExecutor;
    private ClassSetAnalysisData classpathSnapshot;

    public CurrentCompilationAccess(ClassSetAnalyzer classSetAnalyzer, BuildOperationExecutor buildOperationExecutor) {
        this.classSetAnalyzer = classSetAnalyzer;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public ClassSetAnalysisData analyzeOutputFolder(File outputFolder) {
        Timer clock = Time.startTimer();
        ClassSetAnalysisData snapshot = this.classSetAnalyzer.analyzeOutputFolder(outputFolder);
        LOG.info("Class dependency analysis for incremental compilation took {}.", (Object)clock.getElapsed());
        return snapshot;
    }

    public ClassSetAnalysisData getClasspathSnapshot(Iterable<File> entries) {
        if (this.classpathSnapshot == null) {
            Timer clock = Time.startTimer();
            this.classpathSnapshot = ClassSetAnalysisData.merge(this.doSnapshot(entries));
            LOG.info("Created classpath snapshot for incremental compilation in {}.", (Object)clock.getElapsed());
        }
        return this.classpathSnapshot;
    }

    private List<ClassSetAnalysisData> doSnapshot(Iterable<File> entries) {
        return this.snapshotAll(entries).stream().map(CreateSnapshot::getSnapshot).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<CreateSnapshot> snapshotAll(Iterable<File> entries) {
        ArrayList<CreateSnapshot> snapshotOperations = new ArrayList<CreateSnapshot>();
        this.buildOperationExecutor.runAll(buildOperationQueue -> {
            for (File entry : entries) {
                CreateSnapshot operation = new CreateSnapshot(entry);
                snapshotOperations.add(operation);
                buildOperationQueue.add(operation);
            }
        });
        return snapshotOperations;
    }

    private class CreateSnapshot
    implements RunnableBuildOperation {
        private final File entry;
        private ClassSetAnalysisData snapshot;

        private CreateSnapshot(File entry) {
            this.entry = entry;
        }

        @Override
        public void run(BuildOperationContext context) {
            if (this.entry.exists()) {
                this.snapshot = CurrentCompilationAccess.this.classSetAnalyzer.analyzeClasspathEntry(this.entry);
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Create incremental compile snapshot for " + this.entry);
        }

        @Nullable
        public ClassSetAnalysisData getSnapshot() {
            return this.snapshot;
        }
    }
}

